﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <csetjmp>

#define JPEG_INTERNALS          // NOLINT(name/macro)
#include "include/jpeglib.h"
#undef JPEG_INTERNALS

#include <nn/image/image_JpegCommon.h>

/**
    @file libjpeg のエラー処理のための諸々を定義するファイル
 */


namespace nn { namespace image { namespace detail {

/**
    @brief      libjpeg のエラー処理用構造体
    @details    libjpeg が使用する jpeg_error_mgr を SDK 実装のために拡張している。
 */
struct LibjpegErrorInfo : public jpeg::jpeg_error_mgr
{
    jmp_buf jmpContext;         // libjpeg 内でのエラー発生時に SDK の処理に戻るための情報
    volatile JpegStatus status; // 公開 API から返すステータスコード
};

/**
    @brief      libjpeg のエラー処理用関数
    @details    libjpeg が返すエラーコードを見て、Siglo 用エラーコードに変換する。
 */
void HandleLibjpegError(struct jpeg::jpeg_common_struct *cinfo) NN_NOEXCEPT;

}}}
