﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <cstdint>
#include <nn/nn_Macro.h>
#include "edid_BlockTag.h"

namespace nn { namespace edid {
    struct Edid;
    struct DisplayModeInfo;
    struct DisplayTimingInfo;
    struct ImageSizeInfo;
}}

namespace nn { namespace edid { namespace cea861 {

    typedef bool (*BlockVisitor)(const std::uint8_t* pBlock, size_t size, void* pUserData);
    void VisitBlocks(const Edid* pEdid, BlockVisitor visitor, void* pUserData) NN_NOEXCEPT;

    typedef bool (*DataBlockVisitor)(const std::uint8_t* pBlock, size_t size, BlockTag tag, void* pUserData);
    void VisitDataBlocks(const std::uint8_t* pBlock, size_t size, DataBlockVisitor visitor, void* pUserData) NN_NOEXCEPT;

    typedef bool (*DetailedTimingVisitor)(const DisplayModeInfo* pMode, const DisplayTimingInfo* pTiming, const ImageSizeInfo* pImage, void* pUserData);
    void VisitDetailedTimings(const std::uint8_t* pBlock, size_t size, DetailedTimingVisitor visitor, void* pUserData) NN_NOEXCEPT;

    BlockTag GetBlockTag(std::uint16_t value) NN_NOEXCEPT;
    bool ConvertVic(DisplayModeInfo* pOutMode, std::uint8_t vic) NN_NOEXCEPT;

}}}
