﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/diag/detail/diag_DetailTranslation.h>
#include <nn/diag/text/diag_SdkTextLdn.h>

/*
* @file
* @brief    アサート・ログメッセージ翻訳用の辞書にアクセスする API の実装です。
*           このファイルは自動生成されたものなので、変更しないでください。
*/

namespace nn {
namespace diag {
namespace detail {
    const uint8_t nnText_ldn_dictionary[] =
    {
        0xde,
        0x12,
        0x04,
        0x95,
        0x00,
        0x00,
        0x00,
        0x00,
        0x04,
        0x00,
        0x00,
        0x00,
        0x1c,
        0x00,
        0x00,
        0x00,
        0x3c,
        0x00,
        0x00,
        0x00,
        0x05,
        0x00,
        0x00,
        0x00,
        0x5c,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x70,
        0x00,
        0x00,
        0x00,
        0x37,
        0x00,
        0x00,
        0x00,
        0x71,
        0x00,
        0x00,
        0x00,
        0x3a,
        0x00,
        0x00,
        0x00,
        0xa9,
        0x00,
        0x00,
        0x00,
        0x36,
        0x00,
        0x00,
        0x00,
        0xe4,
        0x00,
        0x00,
        0x00,
        0x35,
        0x01,
        0x00,
        0x00,
        0x1b,
        0x01,
        0x00,
        0x00,
        0x23,
        0x00,
        0x00,
        0x00,
        0x51,
        0x02,
        0x00,
        0x00,
        0x27,
        0x00,
        0x00,
        0x00,
        0x75,
        0x02,
        0x00,
        0x00,
        0x2a,
        0x00,
        0x00,
        0x00,
        0x9d,
        0x02,
        0x00,
        0x00,
        0x01,
        0x00,
        0x00,
        0x00,
        0x02,
        0x00,
        0x00,
        0x00,
        0x04,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x03,
        0x00,
        0x00,
        0x00,
        0x00,
        0x4c,
        0x44,
        0x4e,
        0x20,
        0xe3,
        0x83,
        0xa9,
        0xe3,
        0x82,
        0xa4,
        0xe3,
        0x83,
        0x96,
        0xe3,
        0x83,
        0xa9,
        0xe3,
        0x83,
        0xaa,
        0xe3,
        0x81,
        0xaf,
        0xe5,
        0x88,
        0x9d,
        0xe6,
        0x9c,
        0x9f,
        0xe5,
        0x8c,
        0x96,
        0xe3,
        0x81,
        0x95,
        0xe3,
        0x82,
        0x8c,
        0xe3,
        0x81,
        0xa6,
        0xe3,
        0x81,
        0x84,
        0xe3,
        0x81,
        0xbe,
        0xe3,
        0x81,
        0x9b,
        0xe3,
        0x82,
        0x93,
        0xe3,
        0x80,
        0x82,
        0x00,
        0x4c,
        0x44,
        0x4e,
        0x20,
        0xe3,
        0x83,
        0xa9,
        0xe3,
        0x82,
        0xa4,
        0xe3,
        0x83,
        0x96,
        0xe3,
        0x83,
        0xa9,
        0xe3,
        0x83,
        0xaa,
        0xe3,
        0x81,
        0xaf,
        0xe6,
        0x97,
        0xa2,
        0xe3,
        0x81,
        0xab,
        0xe5,
        0x88,
        0x9d,
        0xe6,
        0x9c,
        0x9f,
        0xe5,
        0x8c,
        0x96,
        0xe3,
        0x81,
        0x95,
        0xe3,
        0x82,
        0x8c,
        0xe3,
        0x81,
        0xa6,
        0xe3,
        0x81,
        0x84,
        0xe3,
        0x81,
        0xbe,
        0xe3,
        0x81,
        0x99,
        0xe3,
        0x80,
        0x82,
        0x00,
        0x53,
        0x53,
        0x49,
        0x44,
        0x20,
        0xe3,
        0x81,
        0xaf,
        0x20,
        0x33,
        0x32,
        0x20,
        0xe6,
        0x96,
        0x87,
        0xe5,
        0xad,
        0x97,
        0xe4,
        0xbb,
        0xa5,
        0xe4,
        0xb8,
        0x8b,
        0xe3,
        0x81,
        0xa7,
        0xe6,
        0x8c,
        0x87,
        0xe5,
        0xae,
        0x9a,
        0xe3,
        0x81,
        0x97,
        0xe3,
        0x81,
        0xa6,
        0xe3,
        0x81,
        0x8f,
        0xe3,
        0x81,
        0xa0,
        0xe3,
        0x81,
        0x95,
        0xe3,
        0x81,
        0x84,
        0xe3,
        0x80,
        0x82,
        0x00,
        0x50,
        0x72,
        0x6f,
        0x6a,
        0x65,
        0x63,
        0x74,
        0x2d,
        0x49,
        0x64,
        0x2d,
        0x56,
        0x65,
        0x72,
        0x73,
        0x69,
        0x6f,
        0x6e,
        0x3a,
        0x20,
        0x50,
        0x41,
        0x43,
        0x4b,
        0x41,
        0x47,
        0x45,
        0x20,
        0x56,
        0x45,
        0x52,
        0x53,
        0x49,
        0x4f,
        0x4e,
        0x0a,
        0x52,
        0x65,
        0x70,
        0x6f,
        0x72,
        0x74,
        0x2d,
        0x4d,
        0x73,
        0x67,
        0x69,
        0x64,
        0x2d,
        0x42,
        0x75,
        0x67,
        0x73,
        0x2d,
        0x54,
        0x6f,
        0x3a,
        0x20,
        0x0a,
        0x50,
        0x4f,
        0x54,
        0x2d,
        0x43,
        0x72,
        0x65,
        0x61,
        0x74,
        0x69,
        0x6f,
        0x6e,
        0x2d,
        0x44,
        0x61,
        0x74,
        0x65,
        0x3a,
        0x20,
        0x32,
        0x30,
        0x31,
        0x36,
        0x2d,
        0x30,
        0x33,
        0x2d,
        0x33,
        0x31,
        0x20,
        0x31,
        0x32,
        0x3a,
        0x31,
        0x37,
        0x2b,
        0x30,
        0x39,
        0x30,
        0x30,
        0x0a,
        0x50,
        0x4f,
        0x2d,
        0x52,
        0x65,
        0x76,
        0x69,
        0x73,
        0x69,
        0x6f,
        0x6e,
        0x2d,
        0x44,
        0x61,
        0x74,
        0x65,
        0x3a,
        0x20,
        0x59,
        0x45,
        0x41,
        0x52,
        0x2d,
        0x4d,
        0x4f,
        0x2d,
        0x44,
        0x41,
        0x20,
        0x48,
        0x4f,
        0x3a,
        0x4d,
        0x49,
        0x2b,
        0x5a,
        0x4f,
        0x4e,
        0x45,
        0x0a,
        0x4c,
        0x61,
        0x73,
        0x74,
        0x2d,
        0x54,
        0x72,
        0x61,
        0x6e,
        0x73,
        0x6c,
        0x61,
        0x74,
        0x6f,
        0x72,
        0x3a,
        0x20,
        0x46,
        0x55,
        0x4c,
        0x4c,
        0x20,
        0x4e,
        0x41,
        0x4d,
        0x45,
        0x20,
        0x3c,
        0x45,
        0x4d,
        0x41,
        0x49,
        0x4c,
        0x40,
        0x41,
        0x44,
        0x44,
        0x52,
        0x45,
        0x53,
        0x53,
        0x3e,
        0x0a,
        0x4c,
        0x61,
        0x6e,
        0x67,
        0x75,
        0x61,
        0x67,
        0x65,
        0x2d,
        0x54,
        0x65,
        0x61,
        0x6d,
        0x3a,
        0x20,
        0x4c,
        0x41,
        0x4e,
        0x47,
        0x55,
        0x41,
        0x47,
        0x45,
        0x20,
        0x3c,
        0x4c,
        0x4c,
        0x40,
        0x6c,
        0x69,
        0x2e,
        0x6f,
        0x72,
        0x67,
        0x3e,
        0x0a,
        0x4d,
        0x49,
        0x4d,
        0x45,
        0x2d,
        0x56,
        0x65,
        0x72,
        0x73,
        0x69,
        0x6f,
        0x6e,
        0x3a,
        0x20,
        0x31,
        0x2e,
        0x30,
        0x0a,
        0x43,
        0x6f,
        0x6e,
        0x74,
        0x65,
        0x6e,
        0x74,
        0x2d,
        0x54,
        0x79,
        0x70,
        0x65,
        0x3a,
        0x20,
        0x74,
        0x65,
        0x78,
        0x74,
        0x2f,
        0x70,
        0x6c,
        0x61,
        0x69,
        0x6e,
        0x3b,
        0x20,
        0x63,
        0x68,
        0x61,
        0x72,
        0x73,
        0x65,
        0x74,
        0x3d,
        0x55,
        0x54,
        0x46,
        0x2d,
        0x38,
        0x0a,
        0x43,
        0x6f,
        0x6e,
        0x74,
        0x65,
        0x6e,
        0x74,
        0x2d,
        0x54,
        0x72,
        0x61,
        0x6e,
        0x73,
        0x66,
        0x65,
        0x72,
        0x2d,
        0x45,
        0x6e,
        0x63,
        0x6f,
        0x64,
        0x69,
        0x6e,
        0x67,
        0x3a,
        0x20,
        0x38,
        0x62,
        0x69,
        0x74,
        0x0a,
        0x00,
        0x54,
        0x68,
        0x65,
        0x20,
        0x4c,
        0x44,
        0x4e,
        0x20,
        0x6c,
        0x69,
        0x62,
        0x72,
        0x61,
        0x72,
        0x79,
        0x20,
        0x69,
        0x73,
        0x20,
        0x6e,
        0x6f,
        0x74,
        0x20,
        0x69,
        0x6e,
        0x69,
        0x74,
        0x69,
        0x61,
        0x6c,
        0x69,
        0x7a,
        0x65,
        0x64,
        0x2e,
        0x00,
        0x54,
        0x68,
        0x65,
        0x20,
        0x4c,
        0x44,
        0x4e,
        0x20,
        0x6c,
        0x69,
        0x62,
        0x72,
        0x61,
        0x72,
        0x79,
        0x20,
        0x69,
        0x73,
        0x20,
        0x61,
        0x6c,
        0x72,
        0x65,
        0x61,
        0x64,
        0x79,
        0x20,
        0x69,
        0x6e,
        0x69,
        0x74,
        0x69,
        0x61,
        0x6c,
        0x69,
        0x7a,
        0x65,
        0x64,
        0x2e,
        0x00,
        0x53,
        0x70,
        0x65,
        0x63,
        0x69,
        0x66,
        0x79,
        0x20,
        0x74,
        0x68,
        0x65,
        0x20,
        0x53,
        0x53,
        0x49,
        0x44,
        0x20,
        0x69,
        0x6e,
        0x20,
        0x33,
        0x32,
        0x20,
        0x63,
        0x68,
        0x61,
        0x72,
        0x61,
        0x63,
        0x74,
        0x65,
        0x72,
        0x73,
        0x20,
        0x6f,
        0x72,
        0x20,
        0x6c,
        0x65,
        0x73,
        0x73,
        0x2e,
        0x00,

    };

    const char* nnText_ldn(const char* string)
    {
        return nn::diag::detail::Translate(nnText_ldn_dictionary, string);
    }
}
}
}
