﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/crypto/detail/crypto_Compare.h>

#include <cstring>

namespace nn { namespace crypto { namespace detail {

bool IsSameBytes(const void* pBuffer1, const void* pBuffer2, size_t size) NN_NOEXCEPT
{
    // Aarch32, Aarch64 以外では一致長に依存する時間で処理する
    return std::memcmp(pBuffer1, pBuffer2, size) == 0;
}

}}} // namespace nn::crypto::detail
