﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/crypto/detail/crypto_Compare.h>

namespace nn { namespace crypto { namespace detail {

bool IsSameBytes(const void* pBuffer1, const void* pBuffer2, size_t size) NN_NOEXCEPT
{
    bool isSameSafe;

    __asm__ volatile
    (
        "mov   w3, #0\n"
        "mov   x4, #0\n"
        "b     1f\n"

        "0:\n"
        "ldrb  w5, [%[pBuffer1]]\n"
        "ldrb  w6, [%[pBuffer2]]\n"
        "adds  %[pBuffer1], %[pBuffer1], #1\n"
        "adds  %[pBuffer2], %[pBuffer2], #1\n"
        "eor   w5, w5, w6\n"
        "orr   w3, w3, w5\n"
        "adds  x4, x4, #1\n"

        "1:\n"
        "cmp   x4, %[size]\n"
        "bcc   0b\n"

        "cmp   w3, #0\n"
        "cset  %w[isSameSafe], eq\n"
        : [isSameSafe]"=r"(isSameSafe), [pBuffer1]"+r"(pBuffer1), [pBuffer2]"+r"(pBuffer2)
        : [size]"r"(size)
        : "x3", "x4", "x5", "x6"
    );

    return isSameSafe;
}

}}} // namespace nn::crypto::detail
