﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/crypto/detail/crypto_Clear.h>

namespace nn { namespace crypto { namespace detail {

void ClearMemory(void* dest, size_t size) NN_NOEXCEPT
{
    volatile uint8_t* ptr = static_cast<volatile uint8_t*>(dest);

    for (int i = 0; i < static_cast<int>(size); ++i)
    {
        ptr[i] = 0;
    }
}

}}} // namespace nn::crypto::detail
