﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <cstring>
#include <algorithm>
#include <nn/nn_Common.h>
#include <nn/nn_SdkAssert.h>
#include <nn/crypto/detail/crypto_CbcMacImpl.h>
#include "crypto_UpdateImpl.h"

namespace nn { namespace crypto { namespace detail {

void CbcMacImpl::UpdateGeneric(const void* pData, size_t dataSize) NN_NOEXCEPT
{
    NN_SDK_REQUIRES(m_State == State_Initialized, "Invalid state. Please restart from Initialize().");

    UpdateImpl<void>(this, pData, dataSize); // void is dummy template parameter
}

void CbcMacImpl::ProcessBlocksGeneric(const void* pData, int numBlocks) NN_NOEXCEPT
{
    /* バッファが埋まっていたら先に処理する */
    if (m_BufferedByte == BlockSize)
    {
        ProcessBlock(m_TemporalBlockBuffer);
        m_BufferedByte = 0;
    }

    const uint8_t* pData8 = static_cast<const uint8_t*>(pData);
    uint8_t  tmp[BlockSize];

    while (--numBlocks > 0)
    {
        /* 現在の MAC (= CBC モードでの IV) と入力の XOR を取り */
        for (int i = 0; i < static_cast<int>(BlockSize); i++)
        {
            tmp[i] = pData8[i] ^ m_Mac[i];
        }

        /* 暗号化した結果が新しい IV (= MAC) になる */
        m_pCipherFunction(m_Mac, tmp, m_pCipherContext);

        pData8 += BlockSize;
    }

    // 最後のブロックは平文として保存しておく
    std::memcpy(m_TemporalBlockBuffer, pData8, BlockSize);
    m_BufferedByte = BlockSize;
}

template <>
void CbcMacImpl::Update<AesEncryptor128>(const void* pData, size_t dataSize) NN_NOEXCEPT
{
    // Use Generic version
    UpdateGeneric(pData, dataSize);
}

}}} // namespace nn::crypto::detail
