﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/crypto/crypto_Sha256Generator.h>

namespace nn { namespace crypto {

const uint8_t Sha256Generator::Asn1ObjectIdentifier[Asn1ObjectIdentifierSize] = {
    0x30, 0x31, 0x30, 0x0D, 0x06, 0x09, 0x60, 0x86, 0x48, 0x01, 0x65, 0x03, 0x04, 0x02, 0x01, 0x05,
    0x00, 0x04, 0x020
};

void GenerateSha256Hash(void* pHash, size_t hashSize,
                        const void* pData, size_t dataSize) NN_NOEXCEPT
{
    Sha256Generator sha256;

    sha256.Initialize();
    sha256.Update(pData, dataSize);
    sha256.GetHash(pHash, hashSize);
}

}} // namespace nn::crypto
