﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <cstring>

namespace nn {
    namespace utilTool {

        int8_t StrToInt8(const char *nptr, const char **endptr, int32_t base);
        int16_t StrToInt16(const char *nptr, const char **endptr, int32_t base);
        int32_t StrToInt32(const char *nptr, const char **endptr, int32_t base);
        int64_t StrToInt64(const char *nptr, const char **endptr, int32_t base);
        int8_t WStrToInt8(const wchar_t *nptr, const wchar_t **endptr, int32_t base);
        int16_t WStrToInt16(const wchar_t *nptr, const wchar_t **endptr, int32_t base);
        int32_t WStrToInt32(const wchar_t *nptr, const wchar_t **endptr, int32_t base);
        int64_t WStrToInt64(const wchar_t *nptr, const wchar_t **endptr, int32_t base);
        uint8_t StrToUInt8(const char *nptr, const char **endptr, int32_t base);
        uint16_t StrToUInt16(const char *nptr, const char **endptr, int32_t base);
        uint32_t StrToUInt32(const char *nptr, const char **endptr, int32_t base);
        uint64_t StrToUInt64(const char *nptr, const char **endptr, int32_t base);
        uint8_t WStrToUInt8(const wchar_t *nptr, const wchar_t **endptr, int32_t base);
        uint16_t WStrToUInt16(const wchar_t *nptr, const wchar_t **endptr, int32_t base);
        uint32_t WStrToUInt32(const wchar_t *nptr, const wchar_t **endptr, int32_t base);
        uint64_t WStrToUInt64(const wchar_t *nptr, const wchar_t **endptr, int32_t base);

    }
}
