﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#if !defined(NN_SDK_BUILD_LIBRARY)

/**
* @file
* @brief   ログを出力する API の宣言
*/

#include <nn/nn_Common.h>
#include <nn/diag/diag_LogTypes.h>
#include <nn/diag/detail/diag_DetailBuildSwitch.h>
#include <nn/diag/detail/diag_DetailLog.h>

#if defined(NN_DETAIL_ENABLE_LOG)

#if defined(NN_LOG_USE_DEFAULT_LOCALE_CHARSET) && defined(NN_BUILD_CONFIG_OS_WIN)
#define NN_DETAIL_LOG_USE_DEFAULT_LOCALE_CHARSET_VALUE true
#else
#define NN_DETAIL_LOG_USE_DEFAULT_LOCALE_CHARSET_VALUE false
#endif

/**
* @brief 引数に指定された文字列を、ログとして出力します。
*/
#define NN_LOG(...)                                                     \
    do                                                                  \
    {                                                                   \
        ::nn::diag::LogMetaData logMetaData;                            \
        logMetaData.sourceInfo.lineNumber = __LINE__;                   \
        logMetaData.sourceInfo.fileName = __FILE__;                     \
        logMetaData.sourceInfo.functionName = NN_CURRENT_FUNCTION_NAME; \
        logMetaData.moduleName = "";                                    \
        logMetaData.severity = ::nn::diag::LogSeverity_Info;            \
        logMetaData.verbosity = 0;                                      \
        logMetaData.useDefaultLocaleCharset = NN_DETAIL_LOG_USE_DEFAULT_LOCALE_CHARSET_VALUE;   \
        logMetaData.pAdditionalData = static_cast<void*>(0);            \
        logMetaData.additionalDataBytes = 0;                            \
        ::nn::diag::detail::LogImpl(logMetaData, __VA_ARGS__);          \
    } while (NN_STATIC_CONDITION(0))

/**
* @brief 引数に指定された文字列を、ログとして出力します。引数を可変長引数リストで与えることができます。
*/
#define NN_VLOG(format, args)                                           \
    do                                                                  \
    {                                                                   \
        ::nn::diag::LogMetaData logMetaData;                            \
        logMetaData.sourceInfo.lineNumber = __LINE__;                   \
        logMetaData.sourceInfo.fileName = __FILE__;                     \
        logMetaData.sourceInfo.functionName = NN_CURRENT_FUNCTION_NAME; \
        logMetaData.moduleName = "";                                    \
        logMetaData.severity = ::nn::diag::LogSeverity_Info;            \
        logMetaData.verbosity = 0;                                      \
        logMetaData.useDefaultLocaleCharset = NN_DETAIL_LOG_USE_DEFAULT_LOCALE_CHARSET_VALUE;   \
        logMetaData.pAdditionalData = static_cast<void*>(0);            \
        logMetaData.additionalDataBytes = 0;                            \
        ::nn::diag::detail::VLogImpl(logMetaData, format, args);        \
    } while (NN_STATIC_CONDITION(0))

/**
* @brief 引数に指定された文字列を、ログとして出力します。出力する文字列のバイトサイズを引数で指定します。
*/
#define NN_PUT(text, length)                                            \
    do                                                                  \
    {                                                                   \
        ::nn::diag::LogMetaData logMetaData;                            \
        logMetaData.sourceInfo.lineNumber = __LINE__;                   \
        logMetaData.sourceInfo.fileName = __FILE__;                     \
        logMetaData.sourceInfo.functionName = NN_CURRENT_FUNCTION_NAME; \
        logMetaData.moduleName = "";                                    \
        logMetaData.severity = ::nn::diag::LogSeverity_Info;            \
        logMetaData.verbosity = 0;                                      \
        logMetaData.useDefaultLocaleCharset = NN_DETAIL_LOG_USE_DEFAULT_LOCALE_CHARSET_VALUE;   \
        logMetaData.pAdditionalData = static_cast<void*>(0);            \
        logMetaData.additionalDataBytes = 0;                            \
        ::nn::diag::detail::PutImpl(logMetaData, text, length);         \
    } while (NN_STATIC_CONDITION(0))

#else // #if defined(NN_DETAIL_ENABLE_LOG)

#define NN_LOG(...)             static_cast<void>(0)
#define NN_VLOG(format, args)   static_cast<void>(0)
#define NN_PUT(text, length)    static_cast<void>(0)

#endif // #if defined(NN_DETAIL_ENABLE_LOG)

#endif // #if !defined(NN_SDK_BUILD_LIBRARY)
