﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
    @file
    @brief      image モジュール用の、ログを出力する API の宣言です。
*/

#include <nn/nn_Common.h>
#include <nn/diag/detail/diag_DetailStructuredSdkLog.h>

#define NN_DETAIL_IMAGE_TRACE(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(image, Trace, 0, ##__VA_ARGS__)
#define NN_DETAIL_IMAGE_TRACE_V1(...)               NN_DETAIL_STRUCTURED_SDK_LOG(image, Trace, 1, ##__VA_ARGS__)
#define NN_DETAIL_IMAGE_TRACE_V2(...)               NN_DETAIL_STRUCTURED_SDK_LOG(image, Trace, 2, ##__VA_ARGS__)
#define NN_DETAIL_IMAGE_TRACE_V3(...)               NN_DETAIL_STRUCTURED_SDK_LOG(image, Trace, 3, ##__VA_ARGS__)

#define NN_DETAIL_IMAGE_INFO(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(image, Info, 0, ##__VA_ARGS__)
#define NN_DETAIL_IMAGE_INFO_V1(...)                NN_DETAIL_STRUCTURED_SDK_LOG(image, Info, 1, ##__VA_ARGS__)
#define NN_DETAIL_IMAGE_INFO_V2(...)                NN_DETAIL_STRUCTURED_SDK_LOG(image, Info, 2, ##__VA_ARGS__)
#define NN_DETAIL_IMAGE_INFO_V3(...)                NN_DETAIL_STRUCTURED_SDK_LOG(image, Info, 3, ##__VA_ARGS__)

#define NN_DETAIL_IMAGE_WARN(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(image, Warn, 0, ##__VA_ARGS__)
#define NN_DETAIL_IMAGE_WARN_V1(...)                NN_DETAIL_STRUCTURED_SDK_LOG(image, Warn, 1, ##__VA_ARGS__)
#define NN_DETAIL_IMAGE_WARN_V2(...)                NN_DETAIL_STRUCTURED_SDK_LOG(image, Warn, 2, ##__VA_ARGS__)
#define NN_DETAIL_IMAGE_WARN_V3(...)                NN_DETAIL_STRUCTURED_SDK_LOG(image, Warn, 3, ##__VA_ARGS__)

#define NN_DETAIL_IMAGE_ERROR(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(image, Error, 0, ##__VA_ARGS__)
#define NN_DETAIL_IMAGE_ERROR_V1(...)               NN_DETAIL_STRUCTURED_SDK_LOG(image, Error, 1, ##__VA_ARGS__)
#define NN_DETAIL_IMAGE_ERROR_V2(...)               NN_DETAIL_STRUCTURED_SDK_LOG(image, Error, 2, ##__VA_ARGS__)
#define NN_DETAIL_IMAGE_ERROR_V3(...)               NN_DETAIL_STRUCTURED_SDK_LOG(image, Error, 3, ##__VA_ARGS__)

#define NN_DETAIL_IMAGE_FATAL(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(image, Fatal, 0, ##__VA_ARGS__)
#define NN_DETAIL_IMAGE_FATAL_V1(...)               NN_DETAIL_STRUCTURED_SDK_LOG(image, Fatal, 1, ##__VA_ARGS__)
#define NN_DETAIL_IMAGE_FATAL_V2(...)               NN_DETAIL_STRUCTURED_SDK_LOG(image, Fatal, 2, ##__VA_ARGS__)
#define NN_DETAIL_IMAGE_FATAL_V3(...)               NN_DETAIL_STRUCTURED_SDK_LOG(image, Fatal, 3, ##__VA_ARGS__)

#define NN_DETAIL_IMAGE_VTRACE(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(image, Trace, 0, format, args)
#define NN_DETAIL_IMAGE_VTRACE_V1(format, args)     NN_DETAIL_STRUCTURED_SDK_VLOG(image, Trace, 1, format, args)
#define NN_DETAIL_IMAGE_VTRACE_V2(format, args)     NN_DETAIL_STRUCTURED_SDK_VLOG(image, Trace, 2, format, args)
#define NN_DETAIL_IMAGE_VTRACE_V3(format, args)     NN_DETAIL_STRUCTURED_SDK_VLOG(image, Trace, 3, format, args)

#define NN_DETAIL_IMAGE_VINFO(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(image, Info, 0, format, args)
#define NN_DETAIL_IMAGE_VINFO_V1(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(image, Info, 1, format, args)
#define NN_DETAIL_IMAGE_VINFO_V2(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(image, Info, 2, format, args)
#define NN_DETAIL_IMAGE_VINFO_V3(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(image, Info, 3, format, args)

#define NN_DETAIL_IMAGE_VWARN(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(image, Warn, 0, format, args)
#define NN_DETAIL_IMAGE_VWARN_V1(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(image, Warn, 1, format, args)
#define NN_DETAIL_IMAGE_VWARN_V2(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(image, Warn, 2, format, args)
#define NN_DETAIL_IMAGE_VWARN_V3(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(image, Warn, 3, format, args)

#define NN_DETAIL_IMAGE_VERROR(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(image, Error, 0, format, args)
#define NN_DETAIL_IMAGE_VERROR_V1(format, args)     NN_DETAIL_STRUCTURED_SDK_VLOG(image, Error, 1, format, args)
#define NN_DETAIL_IMAGE_VERROR_V2(format, args)     NN_DETAIL_STRUCTURED_SDK_VLOG(image, Error, 2, format, args)
#define NN_DETAIL_IMAGE_VERROR_V3(format, args)     NN_DETAIL_STRUCTURED_SDK_VLOG(image, Error, 3, format, args)

#define NN_DETAIL_IMAGE_VFATAL(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(image, Fatal, 0, format, args)
#define NN_DETAIL_IMAGE_VFATAL_V1(format, args)     NN_DETAIL_STRUCTURED_SDK_VLOG(image, Fatal, 1, format, args)
#define NN_DETAIL_IMAGE_VFATAL_V2(format, args)     NN_DETAIL_STRUCTURED_SDK_VLOG(image, Fatal, 2, format, args)
#define NN_DETAIL_IMAGE_VFATAL_V3(format, args)     NN_DETAIL_STRUCTURED_SDK_VLOG(image, Fatal, 3, format, args)

#define NN_DETAIL_IMAGE_PUT_TRACE(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(image, Trace, 0, text, length)
#define NN_DETAIL_IMAGE_PUT_TRACE_V1(text, length)  NN_DETAIL_STRUCTURED_SDK_PUT(image, Trace, 1, text, length)
#define NN_DETAIL_IMAGE_PUT_TRACE_V2(text, length)  NN_DETAIL_STRUCTURED_SDK_PUT(image, Trace, 2, text, length)
#define NN_DETAIL_IMAGE_PUT_TRACE_V3(text, length)  NN_DETAIL_STRUCTURED_SDK_PUT(image, Trace, 3, text, length)

#define NN_DETAIL_IMAGE_PUT_INFO(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(image, Info, 0, text, length)
#define NN_DETAIL_IMAGE_PUT_INFO_V1(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(image, Info, 1, text, length)
#define NN_DETAIL_IMAGE_PUT_INFO_V2(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(image, Info, 2, text, length)
#define NN_DETAIL_IMAGE_PUT_INFO_V3(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(image, Info, 3, text, length)

#define NN_DETAIL_IMAGE_PUT_WARN(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(image, Warn, 0, text, length)
#define NN_DETAIL_IMAGE_PUT_WARN_V1(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(image, Warn, 1, text, length)
#define NN_DETAIL_IMAGE_PUT_WARN_V2(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(image, Warn, 2, text, length)
#define NN_DETAIL_IMAGE_PUT_WARN_V3(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(image, Warn, 3, text, length)

#define NN_DETAIL_IMAGE_PUT_ERROR(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(image, Error, 0, text, length)
#define NN_DETAIL_IMAGE_PUT_ERROR_V1(text, length)  NN_DETAIL_STRUCTURED_SDK_PUT(image, Error, 1, text, length)
#define NN_DETAIL_IMAGE_PUT_ERROR_V2(text, length)  NN_DETAIL_STRUCTURED_SDK_PUT(image, Error, 2, text, length)
#define NN_DETAIL_IMAGE_PUT_ERROR_V3(text, length)  NN_DETAIL_STRUCTURED_SDK_PUT(image, Error, 3, text, length)

#define NN_DETAIL_IMAGE_PUT_FATAL(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(image, Fatal, 0, text, length)
#define NN_DETAIL_IMAGE_PUT_FATAL_V1(text, length)  NN_DETAIL_STRUCTURED_SDK_PUT(image, Fatal, 1, text, length)
#define NN_DETAIL_IMAGE_PUT_FATAL_V2(text, length)  NN_DETAIL_STRUCTURED_SDK_PUT(image, Fatal, 2, text, length)
#define NN_DETAIL_IMAGE_PUT_FATAL_V3(text, length)  NN_DETAIL_STRUCTURED_SDK_PUT(image, Fatal, 3, text, length)
