﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief Supported sampling rate flags.
 */

#pragma once

#include <nn/util/util_BitFlagSet.h>

namespace nn { namespace edid {

    /**
     * @brief Sampling rates supported by audio formats.
     */
    struct Sampling
    {
        typedef nn::util::BitFlagSet<8, Sampling>::Flag<0> Rate32Khz;    //!< 32 kHz sampling rate.
        typedef nn::util::BitFlagSet<8, Sampling>::Flag<1> Rate44_1Khz;  //!< 44.1 kHz sampling rate.
        typedef nn::util::BitFlagSet<8, Sampling>::Flag<2> Rate48Khz;    //!< 48 kHz sampling rate.
        typedef nn::util::BitFlagSet<8, Sampling>::Flag<3> Rate88_2Khz;  //!< 88.2 kHz sampling rate.
        typedef nn::util::BitFlagSet<8, Sampling>::Flag<4> Rate96Khz;    //!< 96 kHz sampling rate.
        typedef nn::util::BitFlagSet<8, Sampling>::Flag<5> Rate176_4Khz; //!< 176.4 kHz sampling rate.
        typedef nn::util::BitFlagSet<8, Sampling>::Flag<6> Rate192Khz;   //!< 192 kHz sampling rate.
    };

    /**
     * @brief Set of sampling rates that may be supported by audio formats.
     */
    typedef nn::util::BitFlagSet<8, Sampling> SamplingRateSet;

}}
