﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief Defines for polarity.
 */

#pragma once

namespace nn { namespace edid {

    /**
     * @brief Polarity definitions for HSYNC and VSYNC.
     *
     * @details These definitions are only valid for digital signals.
     */
    enum Polarity
    {
        Polarity_Undefined, //!< Source is an analog signal.
        Polarity_Positive,  //!< Polarity is positive.
        Polarity_Negative,  //!< Polarity is negative.
    };

}}
