﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
* @file
* @brief   アボートオブザーバ関連の API 宣言
*/

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/diag/diag_AbortTypes.h>
#include <nn/diag/diag_AbortTypesForSystem.h>

namespace nn { namespace diag {

typedef void (*SdkAbortObserver)(const SdkAbortInfo& info);

struct SdkAbortObserverHolder
{
    SdkAbortObserver observer;      //!<    アボートオブザーバへのポインタ
    SdkAbortObserverHolder* next;   //!<    SDK が内部で使用するメンバ
    bool isRegistered;              //!<    SDK が内部で使用するメンバ
};

/**
*   @brief      アボートオブザーバのホルダを初期化します。
*
*   @param      abortObserverHolder   初期化するアボートオブザーバのホルダ
*   @param      abortObserver         アボートオブザーバへの関数ポインタ
*   @pre        abortObserverHolder は未登録である必要があります。
*   @post       abortObserverHolder は初期化され、abortObserver が設定されます。
*/
void InitializeSdkAbortObserverHolder(
    SdkAbortObserverHolder* abortObserverHolder,
    SdkAbortObserver abortObserver) NN_NOEXCEPT;

void RegisterSdkAbortObserver(SdkAbortObserverHolder* abortObserverHolder) NN_NOEXCEPT;

/**
*   @brief      アボートオブザーバの登録を解除します。
*
*   @param[in]  abortObserverHolder 登録を解除するアボートオブザーバのホルダのポインタ
*   @pre        abortObserverHolder は登録済みである必要があります。
*   @post       abortObserverHolder は未登録状態になります。
*/
void UnregisterSdkAbortObserver(SdkAbortObserverHolder* abortObserverHolder) NN_NOEXCEPT;

}}
