﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
    @file
    @brief バッファ比較 API の宣言
 */

#include <nn/nn_Common.h>

namespace nn { namespace crypto {

    //! @name バッファ比較
    //! @{

    /**
        @brief      ふたつのバッファの内容が一致するかどうかを取得します。

        @param[in]  pBuffer1 比較対象のバッファへのポインタ。
        @param[in]  pBuffer2 比較対象のバッファへのポインタ。
        @param[in]  size     比較するバイトサイズ。

        @details
        Aarch32, Aarch64 では size にのみ依存し、一致長には依存しない時間で処理をおこなうことを保証します。
     */
    bool IsSameBytes(const void* pBuffer1, const void* pBuffer2, size_t size) NN_NOEXCEPT;

    //! @}

}} // namespace nn::crypto
