﻿using Nintendo.Zarf.v1;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace ZarfCreator.ZarfDefinitionData
{
    public class RelatedZarfInfo : FamilyVersionsSpecifier
    {
        /// <summary>
        /// 互換または依存のある Zarf を表します。
        /// </summary>
        public string Target { get; set; }

        /// <summary>
        /// 互換または依存のあるバージョンのリストを表します。
        /// </summary>
        public ICollection<string> VersionSource { get; set; }

        /// <summary>
        /// 必要フィールドが設定されているかどうかを検証します。必須でないフィールドにはデフォルト値が入ります。
        /// </summary>
        /// <param name="errorMessage">失敗時のエラーメッセージ</param>
        /// <returns>検証結果</returns>
        internal bool Validate(out string errorMessage)
        {
            var msg = new StringBuilder();
            var result = true;

            if (this.Target == null)
            {
                msg.AppendLine("Target must be specified.");
                result = false;
            }

            errorMessage = msg.ToString();
            return result;
        }

        public static explicit operator DependenciesSpecifier(RelatedZarfInfo zarfInfo)
        {
            return new DependenciesSpecifier()
            {
                Family = zarfInfo.Family,
                Versions = zarfInfo.Versions,
            };
        }

        public static explicit operator CompatibilitiesSpecifier(RelatedZarfInfo zarfInfo)
        {
            return new CompatibilitiesSpecifier()
            {
                Family = zarfInfo.Family,
                Versions = zarfInfo.Versions,
            };
        }

        public static explicit operator AddOnToSpecifier(RelatedZarfInfo zarfInfo)
        {
            return new AddOnToSpecifier()
            {
                Family = zarfInfo.Family,
                Versions = zarfInfo.Versions,
            };
        }

        public override bool Equals(object obj)
        {
            if (obj == null)
            {
                return false;
            }

            var relatedZarf = obj as RelatedZarfInfo;
            if (relatedZarf == null)
            {
                return false;
            }

            var result = this.Target == relatedZarf.Target;

            if (this.Family == null || relatedZarf.Family == null)
            {
                if (!(this.Family == null && relatedZarf.Family == null))
                {
                    return false;
                }
            }
            else
            {
                result &= this.Family.Equals(relatedZarf.Family);
            }

            if (this.Versions == null || relatedZarf.Versions == null)
            {
                if (!(this.Versions == null && relatedZarf.Versions == null))
                {
                    return false;
                }
            }
            else
            {
                result &= this.Versions.SequenceEqual(relatedZarf.Versions);
            }

            if (this.VersionSource == null || relatedZarf.VersionSource == null)
            {
                if (!(this.VersionSource == null && relatedZarf.VersionSource == null))
                {
                    return false;
                }
            }
            else
            {
                result &= this.VersionSource.SequenceEqual(relatedZarf.VersionSource);
            }
            return result;
        }

        public override int GetHashCode()
        {
            return this.ToString().GetHashCode();
        }
    }
}
