﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.RegularExpressions;
using System.Threading.Tasks;

namespace ZarfCreator.VersionData
{
    public abstract class VersionBase
    {
        protected const string NumStr = @"(?:0|[1-9][0-9]*)";
        protected const string IdentifierStr = @"[0-9A-Za-z-]+";
        protected static readonly string IdentifiersStr = string.Format(@"{0}(?:\.{0})*", IdentifierStr);
        protected static readonly Regex NumRegex = new Regex(string.Format(@"^{0}$", NumStr));

        public string versionInfo { get; private set; }

        public VersionBase(string versioInfo)
        {
            this.versionInfo = versioInfo;
        }

        public abstract string Read();
    }
}
