﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text.RegularExpressions;
using System.Xml;
using System.Xml.Linq;
using System.Xml.XPath;

namespace ZarfCreator.VersionData.SourceType
{
    public class Xml : VersionBase
    {
        private static readonly Regex IdentifiersRegex = new Regex(string.Format(@"^{0}$", IdentifiersStr));

        public string rootDirectory { get; private set; }

        bool enableRelstep;

        public Xml(string source, string rootDir, bool enableRelstep) : base(source)
        {
            this.rootDirectory = rootDir;
            this.enableRelstep = enableRelstep;
        }

        public override string Read()
        {
            var versionFilePath = Path.Combine(this.rootDirectory, this.versionInfo);

            XDocument versionFileData;
            try
            {
                versionFileData = XDocument.Load(versionFilePath);
            }
            catch (XmlException ex)
            {
                Console.Error.WriteLine("ERROR: {0}\n    {1}", ex.Message, versionFilePath);
                throw;
            }
            catch (IOException)
            {
                Console.Error.WriteLine("ERROR: Failed to open following file.\n    {0}", versionFilePath);
                throw;
            }

            var setting = Properties.Settings.Default;

            var rootEle = versionFileData.Root;

            // Major.Minor.Micro の処理
            var verXpaths = new[]
            {
                setting.MajorVersionXPath,
                setting.MinorVersionXPath,
                setting.MicroVersionXPath
            };

            var verStrs = verXpaths.Select(xpath => rootEle.XPathSelectElement(xpath)?.Value).ToArray();
            if (!verStrs.All(str => str != null && NumRegex.IsMatch(str)))
            {
                Console.Error.WriteLine("ERROR: Invalid xml files has specified.\n    {0}", versionFilePath);
                throw new ArgumentException("Invalid file has specified.");
            }
            var verStr = string.Format("{0}.{1}.{2}", verStrs);

            var additionalStrs = new List<string>();

            // リリースステップの処理
            if (this.enableRelstep)
            {
                var relStepStr = rootEle.XPathSelectElement(setting.RelstepVersionXPath)?.Value;
                if (relStepStr != null)
                {
                    additionalStrs.Add(string.Format(setting.RelstepFormat1, relStepStr));
                }
                else
                {
                    var relStepXpaths = new[] { setting.MajorRelstepVersionXPath, setting.MinorRelstepVersionXPath };
                    var relStepStrs = relStepXpaths.Select(str => rootEle.XPathSelectElement(str)?.Value).ToArray();
                    if (relStepStrs.All(ele => ele != null))
                    {
                        additionalStrs.Add(string.Format(setting.RelstepFormat2, relStepStrs));
                    }
                }
            }

            // Description の処理
            var descStr = rootEle.XPathSelectElement(setting.DescriptionXPath)?.Value;
            if (descStr != null)
            {
                // Description がセマンティックバージョンとして有効な場合は追加する。
                if (IdentifiersRegex.IsMatch(descStr))
                {
                    additionalStrs.Add(descStr);
                }
                else
                {
                    Console.Error.WriteLine("WARNING: Specified neither alphanumeric nor '-' in Description.\n    {0}", versionFilePath);
                }
            }

            if (additionalStrs.Count > 0)
            {
                verStr += "+" + string.Join(".", additionalStrs);
            }

            return verStr;
        }
    }
}

