﻿using Newtonsoft.Json;
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace ZarfCreator.MetaData
{
    internal class ZarfSpec
    {
        private JsonSerializerSettings serializerSettings { get; set; }

        /// <summary>
        /// ZarfSpec クラスの新しいインスタンスを作成します。
        /// </summary>
        /// <param name="serializerSettings"></param>
        public ZarfSpec(JsonSerializerSettings serializerSettings)
        {
            this.serializerSettings = serializerSettings;
        }

        /// <summary>
        /// ZarfSpec ファイルを作成します。
        /// </summary>
        /// <param name="outputDirectory">ファイルの出力先ディレクトリ</param>
        internal void Create(string outputDirectory)
        {
            try
            {
                var content = this.CreateContent();
                File.WriteAllText(outputDirectory, content);
            }
            catch (Exception)
            {
                Console.Error.WriteLine("ERROR: Failed to create the ZarfSpec file.");
                throw;
            }
        }

        private string CreateContent()
        {
            try
            {
                var content = JsonConvert.SerializeObject("Zarf/1", this.serializerSettings);
                return content;
            }
            catch (Exception)
            {
                Console.Error.WriteLine("ERROR: Failed to create json contents.");
                throw;
            }
        }

    }
}
