﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace TestRunner
{
    using System;

    /// <summary>
    /// エントリーポイントを定義します。
    /// </summary>
    internal static class Program
    {
        /// <summary>
        /// エントリーポイントです。
        /// </summary>
        /// <param name="args">コマンドラインオプションです。</param>
        internal static void Main(string[] args)
        {
            try
            {
                var option = new CommandLineOption();

                option.Parse(args);

                if (option.EnablesHelpMode)
                {
                    Console.Error.WriteLine(CommandLineOption.GetHelpMessage());

                    Environment.Exit(1);
                }

                var runner = new TestRunner()
                {
                    Option = option
                };

                int exitCode = runner.Run();

                Environment.Exit(exitCode);
            }
            catch (Exception ex)
            {
                Console.Error.WriteLine("Error: {0}", ex.Message);

                Environment.Exit(1);
            }
        }
    }
}
