﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace TestRunner.Executer
{
    /// <summary>
    /// ビルドコンテキストです。
    /// </summary>
    public sealed class BuildContext
    {
        /// <summary>
        /// ログをコンソールにも出力するか否かを表す値を取得または設定します。
        /// </summary>
        public bool EnablesVerboseMode { get; set; }

        /// <summary>
        /// テストコンテキストを取得または設定します。
        /// </summary>
        public TestContext[] TestContexts { get; set; }

        /// <summary>
        /// テストの終了を検知するイベントの名前を取得または設定します。
        /// </summary>
        public string ListenerName { get; set; } = string.Empty;

        /// <summary>
        /// テストの終了を通知するイベントの名前を取得または設定します。
        /// </summary>
        public string NotifierName { get; set; } = string.Empty;
    }
}
