﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace SystemUpdaterNx.UpdateJoycon
{
    using System.ComponentModel.Composition;
    using System.IO;
    using System.Text;
    using System.Threading;
    using SystemUpdaterNx.Common;
    using TargetShell.Library;
    using TargetShell.CommandPluginBase;
    using TargetShell.DevicePluginBase;

    /// <summary>
    /// ジョイコンのFW更新を行うクラス
    /// </summary>
    [Export(typeof(IDevicePluginInterface<CommandParameter>))]
    public class Nx :
            BaseDevicePlugin<CommandParameter>, IDevicePluginInterface<CommandParameter>
    {
        /// <summary>
        /// ControllerFirmwareUpdater.nsp へのパス
        /// </summary>
        public const string ControllerFirmwareUpdater =
                @"TargetTools\NX-NXFP2-a64\ControllerFirmwareUpdater\Release\ControllerFirmwareUpdater.nsp";

        /// <summary>
        /// コンストラクタ
        /// </summary>
        public Nx()
        {
            this.ParallelModeFlag = true;
        }

        /// <summary>
        /// デバイスプラグイン実行メソッド
        /// </summary>
        /// <param name="parameter">コマンドのパラメータ</param>
        /// <param name="successDeviceCount">成功デバイスの数</param>
        protected override void SpecificProcessDevicePlugin(
                CommandParameter parameter, ref int successDeviceCount)
        {
            try
            {
                var runOnTargetCommandBuilder = new StringBuilder();
                // RunOnTarget.exeのコマンドを構築
                runOnTargetCommandBuilder.AppendFormat(" {0}", Path.Combine(
                        parameter.NintendoSdkRoot, ControllerFirmwareUpdater));
                if (parameter.Verbose)
                {
                    runOnTargetCommandBuilder.AppendFormat(" --verbose");
                }
                if (!string.IsNullOrEmpty(parameter.TargetEntry.SerialNumber))
                {
                    runOnTargetCommandBuilder.AppendFormat(" --target={0}",
                            parameter.TargetEntry.SerialNumber);
                }
                runOnTargetCommandBuilder.AppendFormat(" -- --auto");
                // RunOnTarget.exeからControllerFirmwareUpdater.nspを呼び出して
                // ジョイコンのFW更新を行う
                var returnCode = TargetShellLibrary.InvokeExe(
                        Path.Combine(parameter.NintendoSdkRoot,
                                ConstantsNx.RunOnTargetExe),
                        runOnTargetCommandBuilder.ToString(), parameter.SerialDirectroy,
                        parameter.TargetEntry.SerialNumber,
                        CommonConstants.OutputLogName);
                Interlocked.Increment(ref successDeviceCount);
            }
            catch (TargetShellLibraryException exception)
            {
                TargetShellLibrary.PrintException(exception);
            }
        }
    }
}
