﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace SystemUpdaterNx.DeleteSaveData
{
    using System;
    using Properties;
    using TargetShell.CommandPluginBase;
    using TargetShell.Library;
    using TargetShell.PluginInterface;

    /// <summary>
    /// セーブデータ消去機能プラグインの定数定義
    /// </summary>
    public class Constants
    {
        /// <summary>
        /// サブコマンド delete-savedata の文字列
        /// <summary>
        public const string SubCommand = "delete-savedata";
        /// <summary>
        /// オプション all-delete の文字列
        /// <summary>
        public const string OptionallAllDelete = "all-delete";
        /// <summary>
        /// オプション application-id の文字列
        /// <summary>
        public const string OptionApplicationId = "application-id";
    }

    /// <summary>
    /// サブコマンドのオプション引数
    /// </summary>
    public class SubCommandArgument : BaseCommand<CommandParameter>, ISubCommandArgument
    {
        /// <summary>
        /// コンストラクタ
        /// </summary>
        public SubCommandArgument()
        {
            this.SubCommandName = Constants.SubCommand;
        }

        /// <summary>
        /// コマンドラインパーサにコマンドを登録します。
        /// </summary>
        /// <param name="commandLineParser">コマンドラインパーサです。</param>
        public void RegisterWith(CommandLineParser commandLineParser)
        {
            // サブコマンド
            var subcommand = commandLineParser.ActionCommand
                .AddCommand(Constants.SubCommand);
            subcommand
                .GetBuilder()
                .SetDescription(SetupTargetResources.DeleteSaveDataDescription);

            // 共通オプション
            this.OptionArgs.CommonArgs.RegisterWith(subcommand);

            // サブコマンド固有のオプション
            subcommand
                .AddValueOption(Constants.OptionApplicationId,
                    new Action<string>(x => this.DevicePluginArgs.ApplicationId = x))
                .GetBuilder()
                .SetDescription(SetupTargetResources.DeleteSaveDataDescriptionApplicationId);
            subcommand
                .AddFlagOption(Constants.OptionallAllDelete,
                    new Action(() => this.DevicePluginArgs.AllDelete = true))
                .GetBuilder()
                .SetDescription(SetupTargetResources.DeleteSaveDataDescriptionAllDelete);
        }
    }
}
