﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace PublicNx.SettingCommon
{
    using System;
    using System.Collections.Generic;
    using TargetShell.Library;
    using TargetShell.PluginInterface;

    public class SettingsCommon
    {
        /// <summary>
        /// デバイスごとのプラグインを読み込む
        /// </summary>
        public void LoadDevicePlugin()
        {
            // Settingはデバイスプラグインを持たないので処理は無しです
        }

        /// <summary>
        /// デバイスの情報を取得する
        /// </summary>
        public List<DevicePluginInfo> GetDevicePluginInfo()
        {
            var devicePluginInfo = new List<DevicePluginInfo>();
            devicePluginInfo = TargetShellLibrary.GetDeviceInfoNx();
            return devicePluginInfo;
        }

        /// <summary>
        /// サブコマンドを実行する
        /// </summary>
        /// <param name="subCommandArgument">サブコマンド引数</param>
        /// <param name="deviceList">デバイスのリスト</param>
        /// <param name="devicePlugin">デバイスプラグイン</param>
        /// <returns>true：成功  false：失敗</returns>
        public CommandParameter PrepareSettingPlugin(ISubCommandArgument subCommandArgument)
        {
            try
            {
                if (!IsRequiredOption(TargetShellLibrary.CastParameter<CommandParameter>(
                    subCommandArgument.OptionArgs.DevicePluginArgs)))
                {
                    throw new TargetShellLibraryException("Please review the option.");
                }
                subCommandArgument.OptionArgs.DevicePluginArgs.LogOutputDir =
                        TargetShellLibrary.CreateDateLogDirectory(
                                subCommandArgument.OptionArgs.CommonArgs.OutputDirectory);
            }
            catch (TargetShellLibraryException message)
            {
                throw message;
            }
            return TargetShellLibrary.CastParameter<CommandParameter>(
                    subCommandArgument.OptionArgs.DevicePluginArgs);
        }

        /// <summary>
        /// 期待オプション確認
        /// </summary>
        /// <param name="parameter">コマンドパラメータ</param>
        /// <returns>true:設定されている false:設定されていない</returns>
        private static bool IsRequiredOption(CommandParameter parameter)
        {
            // --file-pathと--directory-pathが両方設定されている場合はエラーとする
            if (!string.IsNullOrWhiteSpace(parameter.FilePath) &&
                    !string.IsNullOrWhiteSpace(parameter.DirectoryPath))
            {
                Console.WriteLine(
                        "Both file-path and directory-path are set. Please only set one.");
                return false;
            }
            return true;
        }
    }
}
