﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace PrivateNx.InitializeBuildImage
{
    using TargetShell.CommandPluginBase;

    /// <summary>
    /// インストールプラグインのコマンドパラメータ
    /// </summary>
    public class CommandParameter : BaseCommandParameter
    {
        /// <summary>
        /// SDKでビルドしたイメージで初期化する場合のパラメータ
        /// </summary>
        public InitializeCommandParameterForBuildImange BuildImageParam { get; set; }

        /// <summary>
        /// コンストラクタ
        /// </summary>
        public CommandParameter()
        {
            this.BuildImageParam = new InitializeCommandParameterForBuildImange();
        }
    }

    /// <summary>
    /// 初期化イメージ(initimg)で初期化する する時のパラメータ
    /// </summary>
    public class InitializeCommandParameterForBuildImange
    {
        /// <summary>
        /// プラットフォームネーム
        /// </summary>
        public string PlatformName { get; set; }

        /// <summary>
        /// ビルドタイプ
        /// </summary>
        public string BuildType { get; set; }

        /// <summary>
        /// キータイプ
        /// </summary>
        public string KeyType { get; set; }

        /// <summary>
        /// ブートタイプ
        /// </summary>
        public string BootType { get; set; }

        /// <summary>
        /// コネクションタイプ
        /// </summary>
        public string ConnectionType { get; set; }

        /// <summary>
        /// 署名付きOS/署名なしOS
        /// </summary>
        public string SignedType { get; set; }

        /// <summary>
        /// デベロッパータイプ
        /// </summary>
        public string DeveloperType { get; set; }

        /// <summary>
        /// Phidgetsの有効/無効
        /// </summary>
        public bool PhidgetsOff { get; set; }

        /// <summary>
        /// 初期化後にリセットして、「HelloWorld」の実行
        /// 「HelloWorld」を実行しない場合、初期化後にリセットも行いません
        /// ※SDEV専用
        /// </summary>
        public bool SkipHelloWorld { get; set; }

        /// <summary>
        /// コンストラクタ
        /// </summary>
        public InitializeCommandParameterForBuildImange()
        {
            PlatformName = "NXFP2-a64";
            BuildType = "Develop";
            KeyType = "Auto";
            BootType = "Nand";
            ConnectionType = "HostBridge";
            SignedType = "Unsigned";
            DeveloperType = "Internal";
            PhidgetsOff = false;
            SkipHelloWorld = false;
        }
    }
}
