﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Nintendo.PlatformCodeFilter
{
    /// <summary>
    /// StringIndexInfo のリストを保持し、オフセット値から該当する StringIndexInfo を取得できるように
    /// するクラスです。
    /// </summary>
    internal class StringIndexInfoFinder
    {
        private readonly StringOffsetComparer _comparer = new StringOffsetComparer();
        private readonly List<StringIndexInfo> _list;

        public StringIndexInfoFinder(List<StringIndexInfo> list)
        {
            _list = list;
        }

        /// <summary>
        /// 指定したオフセットが含まれる StringIndexInfo のインデックスを探します。
        /// </summary>
        /// <param name="offset"></param>
        /// <returns></returns>
        public int FindIndex(int offset)
        {
            var findIndex = _list.BinarySearch(new StringIndexInfo(offset, -1, 0), _comparer);
            if (findIndex < 0) // 見つからなかったときは最後を指すようにする。
            {
                findIndex = _list.Count - 1;
            }
            return findIndex;
        }

        /// <summary>
        /// 指定したオフセットが含まれる StringIndexInfo を探します。
        /// </summary>
        /// <param name="offset"></param>
        /// <returns></returns>
        public StringIndexInfo Find(int offset)
        {
            return _list[FindIndex(offset)];
        }

        internal class StringOffsetComparer : IComparer<StringIndexInfo>
        {
            public int Compare(StringIndexInfo x, StringIndexInfo y)
            {
                int sa;
                int aSt;
                int aEt;
                int b;
                if (y.Length == -1)
                {
                    aSt = x.Index;
                    aEt = x.Index + x.Length;
                    b = y.Index;
                    sa = 1;
                }
                else
                {
                    aSt = y.Index;
                    aEt = y.Index + y.Length;
                    b = x.Index;
                    sa = -1;
                }

                if (aSt > b)
                {
                    return sa;
                }
                else
                {
                    // ここでは、aSt <= b がなりたつ。
                    if (aSt == aEt)
                    {
                        if (aSt == b)
                        {
                            return 0;
                        }
                        else
                        {
                            return -sa;
                        }
                    }
                    else
                    {
                        if (aEt > b)
                        {
                            return 0;
                        }
                        else
                        {
                            return -sa;
                        }
                    }
                }
            }
        }
    }
}
