﻿namespace Nintendo.PlatformCodeFilter

open System
open System.Collections.Generic
open System.IO
open System.Text
open FParsec

module MakefileFilter =
    /// <summary>
    /// ファイル中のプラットフォーム固有コードのうち、対象外となっているコードを
    /// 取り除くようにします。
    /// </summary>
    /// <param name="inFile">対象のファイルのパス。</param>
    let filter (outFile: string) (inFile: string) passagePlatforms platformDefineList =
        // TODO: バックスラッシュによる改行のエスケープ
        //          改行の直前にバックスラッシュがある場合は次の動作になる。
        //          改行の直前にあるバックスラッシュを置くと、空白に置き換わる
        //          改行の直前にあるバックスラッシュから連続して前に
        //          バックスラッシュを置く場合は、バックススラッシュをバックスラッシュ自身で
        //          エスケープする。
        //          例えば 「\\\+改行」となっている場合は、「\ + 空白」と解釈される。
        //          理屈として、連続するバックスラッシュの個数は奇数になるはず。
        //          偶数個置いた場合、エスケープ処理が全くされなくなる。
        //          つまり、「\\\\+改行」の場合はそのまま「\\\\+改行」となる。

        // TODO: NW_PLATFORMと比較する

        // INFO: 行頭からのスペース以外の文字までのスペースは削除されるようだ。
        //          これは、バックスラッシュによるエスケープされた行でも同じ。
        false

