﻿namespace PackageCreator
{
    using System;
    using System.Collections.Generic;
    using System.IO;
    using System.Linq;
    using System.Text;
    using System.Threading.Tasks;
    using YamlDotNet.RepresentationModel;

    /// <summary>
    /// YAML ファイルを読むクラス
    /// </summary>
    public static class YamlDataReader
    {
        #region YAML ファイルの読み込み
        /// <summary>
        /// YAML ファイルから情報を読み込みます。
        /// </summary>
        /// <param name="reader">読み込む YAML のストリーム</param>
        /// <param name="rootNodeName">ルートのハッシュ名</param>
        /// <param name="scalarNodes">読み込みたいハッシュ名</param>
        /// <param name="sequenceNodes">読み込みたい配列名</param>
        public static Dictionary<string, object> Read(StreamReader reader, string rootNodeName)
        {
            YamlStream yaml = new YamlStream();
            yaml.Load(reader);

            var mapping = (YamlMappingNode)yaml.Documents[0].RootNode;
            var root = (YamlMappingNode)mapping.Children[new YamlScalarNode(rootNodeName)];

            return (Dictionary<string, object>)ReadNodes(root);
        }

        private static object ReadNodes(YamlNode node)
        {
            if (node is YamlScalarNode)
            {
                return (node as YamlScalarNode).Value;
            }

            if (node is YamlSequenceNode)
            {
                List<object> result = new List<object>();
                foreach (YamlNode child in (node as YamlSequenceNode).Children)
                {
                    result.Add(ReadNodes(child));
                }
                return result;
            }

            if (node is YamlMappingNode)
            {
                Dictionary<string, object> result = new Dictionary<string, object>();
                foreach (var child in (node as YamlMappingNode).Children)
                {
                    result.Add((child.Key as YamlScalarNode).Value, ReadNodes(child.Value));
                }
                return result;
            }

            Console.Error.WriteLine("ERROR: Failed to parse the YML file.");
            throw new YamlDotNet.Core.YamlException();
        }
        #endregion
    }
}
