﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.IO;

namespace NxAgingLogAnalyzer
{
    public class Program
    {
        public static void Main(string[] args)
        {
            LogAnalyzerArgs opt = new LogAnalyzerArgs();
            try
            {
                if (!opt.ParseArgs(args))
                {
                    return;
                }
            }
            catch
            {
                Environment.ExitCode = 1;
                return;
            }

            var path = opt.Params.Path;
            var timeForAnalysis = DateTime.Parse(opt.Params.Timepoint);

            // 分析結果
            DateTime firstTimeStamp = timeForAnalysis;
            var lineCount = 0;
            var dataCount = new SortedDictionary<string, int>();
            var lastModuleStatus = new SortedDictionary<string, string>();

            // ログを分析
            using (var reader = new StreamReader(path))
            {
                string line;
                while ((line = reader.ReadLine()) != null)
                {
                    lineCount += 1;

                    try
                    {
                        DateTime time = DateTime.Parse(line.Substring(1, line.IndexOf(']') - 1));

                        // タイムスタンプとコメントを削除
                        string data = line.Substring(line.IndexOf(']') + 1);
                        if (data.Contains("#"))
                        {
                            data = data.Remove(data.IndexOf('#'));
                        }
                        data = data.Trim();

                        string module = data.Split(' ')[0];
                        string status = data.Split(' ')[1];

                        if (firstTimeStamp > time)
                        {
                            firstTimeStamp = time;
                        }

                        if (time > timeForAnalysis)
                        {
                            break;
                        }

                        lastModuleStatus[module] = status;
                        if (dataCount.ContainsKey(data))
                        {
                            dataCount[data] += 1;
                        }
                        else
                        {
                            dataCount[data] = 1;
                        }
                    }
                    catch
                    {
                        Console.WriteLine(string.Format("Parse ERROR at line {0}.", lineCount));
                        Console.WriteLine();
                        Console.WriteLine(string.Format("> {0}", line));
                        Console.WriteLine();
                        Console.WriteLine("The log file may be corrupted.");
                        Environment.ExitCode = 1;
                        return;
                    }
                }
            }

            Console.WriteLine("Aging time: {0} ", (timeForAnalysis - firstTimeStamp).ToString("c"));
            Console.WriteLine();

            Console.WriteLine("Log line count:{0}", lineCount);
            Console.WriteLine();

            Console.WriteLine("Data count:");
            foreach (var pair in dataCount)
            {
                Console.WriteLine("    {0}: {1}", pair.Key, pair.Value);
            }
            Console.WriteLine();

            Console.WriteLine("Last module status:");
            foreach (var pair in lastModuleStatus)
            {
                Console.WriteLine("    {0}: {1}", pair.Key, pair.Value);
            }
            Console.WriteLine();
        }
    }
}
