﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.Threading;

using System.IO;
using System.IO.Ports;

namespace NxAgingHelper
{
    public class UartLogger
    {
        private SdevUartLogger m_SdevUartLogger = new SdevUartLogger();
        private EdevUartLogger m_EdevUartLogger = new EdevUartLogger();

        private bool m_StartedForSdev;
        private bool m_StartedForEdev;

        private static bool m_StartWithTimeStamp = true;
        private static bool m_InEscapeSequence = false;

        public delegate void ExceptionHandler(Exception e);
        public event ExceptionHandler ExceptionHandleEvent
        {
            add
            {
                m_SdevUartLogger.ExceptionHandleEvent += value;
                m_EdevUartLogger.ExceptionHandleEvent += value;
            }
            remove
            {
                m_SdevUartLogger.ExceptionHandleEvent -= value;
                m_EdevUartLogger.ExceptionHandleEvent -= value;
            }
        }

        public delegate void ReceiveHandler(string data);
        public event ReceiveHandler ReceiveHandleEvent
        {
            add
            {
                m_SdevUartLogger.ReceiveHandleEvent += value;
                m_EdevUartLogger.ReceiveHandleEvent += value;
            }
            remove
            {
                m_SdevUartLogger.ReceiveHandleEvent -= value;
                m_EdevUartLogger.ReceiveHandleEvent -= value;
            }
        }

        public void StartForSdev(string hostname, string logFilePath)
        {
            m_SdevUartLogger.Start(hostname, logFilePath);
            m_StartedForSdev = true;
        }

        public void StartForEdev(string portName, string logFilePath)
        {
            m_EdevUartLogger.Start(portName, logFilePath);
            m_StartedForEdev = true;
        }

        public void Stop()
        {
            if (m_StartedForSdev)
            {
                m_SdevUartLogger.Stop();
                m_StartedForSdev = false;
            }
            if (m_StartedForEdev)
            {
                m_EdevUartLogger.Stop();
                m_StartedForEdev = false;
            }
        }

        public static string Format(string text)
        {
            DateTime now = DateTime.Now;
            string timeStamp = now.ToString("[yyyy-MM-dd HH:mm:ss.fff]");

            var builder = new StringBuilder();

            if (m_StartWithTimeStamp)
            {
                builder.Append(timeStamp);
                m_StartWithTimeStamp = false;
            }

            bool endsWithLineFeed = text.EndsWith("\n");
            if (endsWithLineFeed)
            {
                text = text.Remove(text.Length - 1);
            }

            foreach (var c in text)
            {
                if (!m_InEscapeSequence && c == '\x33')
                {
                    m_InEscapeSequence = true;
                    continue;
                }
                if (m_InEscapeSequence && c == 'm')
                {
                    m_InEscapeSequence = false;
                    continue;
                }

                if (!m_InEscapeSequence)
                {
                    builder.Append(c);
                    if (c == '\n')
                    {
                        builder.Append(timeStamp);
                    }
                }
            }

            if (endsWithLineFeed)
            {
                builder.Append('\n');
                m_StartWithTimeStamp = true;
            }

            return builder.ToString();
        }
    }
}
