﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.IO;
using System.Threading;
using System.Net;
using System.Net.Sockets;

namespace NxAgingHelper
{
    public class SdevUartLogger
    {
        public event UartLogger.ExceptionHandler ExceptionHandleEvent;
        public event UartLogger.ReceiveHandler ReceiveHandleEvent;

        private CancellationTokenSource m_TokenSource;

        public void Start(string hostname, string logFilePath)
        {
            var socket = new Socket(AddressFamily.InterNetwork, SocketType.Stream, ProtocolType.Tcp);
            socket.Connect(new IPEndPoint(IPAddress.Parse(hostname), 10023));

            m_TokenSource = new CancellationTokenSource();

            Task.Run(() =>
            {
                var formatter = new UartLoggerFormatter();

                using (var writer = new StreamWriter(logFilePath, true))
                using (var reader = new StreamReader(new NetworkStream(socket)))
                {
                    while (!m_TokenSource.Token.IsCancellationRequested)
                    {
                        try
                        {
                            var buffer = new char[256];

                            var task = reader.ReadAsync(buffer, 0, buffer.Length);
                            task.Wait(m_TokenSource.Token);

                            var readSize = task.Result;
                            if (readSize > 0)
                            {
                                Array.Resize(ref buffer, readSize);
                                string text = formatter.Format(new string(buffer));

                                ReceiveHandleEvent?.Invoke(text);

                                writer.Write(text);
                                writer.Flush();
                            }

                            if (m_TokenSource.Token.IsCancellationRequested)
                            {
                                break;
                            }
                        }
                        catch (OperationCanceledException)
                        {
                            break;
                        }
                        catch (Exception e)
                        {
                            if (ExceptionHandleEvent != null)
                            {
                                ExceptionHandleEvent(new Exception("Error occurred in Uart logging.", e));
                                break;
                            }
                            else
                            {
                                throw;
                            }
                        }
                    }

                    m_TokenSource.Dispose();
                }
            });
        }

        public void Stop()
        {
            m_TokenSource.Cancel();
        }
    }
}
