﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Nintendo.Foundation.IO;

namespace NxAgingHelper
{
    public class HelperCommandParams
    {
        // --------
        // Config YAML path

        [CommandLineOption("config",
            IsRequired = true,
            Description = "Configuration YAML file path.",
            ValueName = "String")]
        public string Config { get; set; }

        // --------
        // SDEV or EDEV

        [CommandLineOption("sdev",
            IsRequired = false,
            DefaultValue = null,
            Description = "Use SDEV and specify IP address of SDEV (ex. '192.168.1.1').",
            ValueName = "String")]
        public string Sdev { get; set; }

        [CommandLineOption("edev",
            IsRequired = false,
            DefaultValue = null,
            Description = "Use EDEV and specify COM port of EDEV (ex. 'COM1').",
            ValueName = "String")]
        public string Edev { get; set; }

        // --------
        // Event log

        [CommandLineOption("event-log-path",
            IsRequired = false,
            Description = "Path of event log file (default: yyyyMMdd_Event.log).",
            ValueName = "String")]
        public string EventLogPath { get; set; }

        // --------
        // Uart log

        [CommandLineOption("enable-uart-log",
            IsRequired = false,
            Description = "Enable uart logging.",
            DefaultValue = false,
            ValueName = "Bool")]
        public bool EnableUartLog { get; set; }

        [CommandLineOption("continue-uart-log-after-aging",
            IsRequired = false,
            Description = "Continue uart logging after aging time finished.",
            ValueName = "Bool")]
        public bool ContinueUartLogAfterAging { get; set; }

        [CommandLineOption("uart-log-path",
            IsRequired = false,
            Description = "Path of uart log file (default: yyyyMMdd_Uart.log).",
            ValueName = "String")]
        public string UartLogPath { get; set; }

        // --------
        // Enable events

        [CommandLineOption("enable-mcci-event",
            IsRequired = false,
            Description = "Enable MCCI Type-C exciser switching event.",
            DefaultValue = false,
            ValueName = "Bool")]
        public bool EnableMcciEvent { get; set; }

        [CommandLineOption("enable-hdmi-event",
            IsRequired = false,
            Description = "Enable HDMI switching event.",
            DefaultValue = false,
            ValueName = "Bool")]
        public bool EnableHdmiEvent { get; set; }

        [CommandLineOption("enable-power-usb-event",
            IsRequired = false,
            Description = "Enable PowerUSB switching event.",
            DefaultValue = false,
            ValueName = "Bool")]
        public bool EnablePowerUsbEvent { get; set; }

        [CommandLineOption("enable-sdev-usb-event",
            IsRequired = false,
            Description = "Enable SDEV USB switching event.",
            DefaultValue = false,
            ValueName = "Bool")]
        public bool EnableSdevUsbEvent { get; set; }

        [CommandLineOption("enable-power-button-event",
            IsRequired = false,
            Description = "Enable power button event.",
            DefaultValue = false,
            ValueName = "Bool")]
        public bool EnablePowerButtonEvent { get; set; }

        [CommandLineOption("enable-battery-emulation-event",
            IsRequired = false,
            Description = "Enable battery emulation event.",
            DefaultValue = false,
            ValueName = "Bool")]
        public bool EnableBatteryEmulationEvent { get; set; }

        // --------
        // Address and port of controllers

        [CommandLineOption("mcci-com-port-name",
            IsRequired = false,
            Description = "COM port name of MCCI Type-C exciser (ex. 'COM1').",
            ValueName = "String")]
        public string McciPort { get; set; }

        [CommandLineOption("hdmi-switcher-ip-addr",
            IsRequired = false,
            DefaultValue = "192.168.1.72",
            Description = "IP address of Gefen HDMI Switcher (ex. '192.168.1.72').",
            ValueName = "String")]
        public string HdmiSwitcherIpAddr { get; set; }

        [CommandLineOption("hdmi-switcher-com-port-name",
            IsRequired = false,
            Description = "COM port name of Gefen HDMI Switcher (ex. 'COM1').",
            ValueName = "String")]
        public string HdmiSwitcherPortName { get; set; }

        // --------
        // Time

        [CommandLineOption("time",
            IsRequired = false,
            Description = "Time to continue aging (seconds). Specify a negative value for endless aging.",
            DefaultValue = -1,
            ValueName = "Integer")]
        public int Time { get; set; }

        // --------
        // RegExWatch

        [CommandLineOption("reg-ex-stop-aging",
            IsRequired = false,
            Description = "Stop aging if the regular expression matches with uart log.",
            DefaultValue = false,
            ValueName = "Bool")]
        public bool RegExWatchStopAging { get; set; }

        [CommandLineOption("reg-ex",
            IsRequired = false,
            Description = "Regular expression text to collate it with uart log.",
            DefaultValue = null,
            ValueName = "String")]
        public string RegExWatchString { get; set; }
    }
}
