﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.Diagnostics;

namespace NxAgingHelper
{
    public interface ICommand
    {
        void Run(ControllerSet controllerSet);
    }

    public class HdmiCommand : ICommand
    {
        public bool Enable { get; set; }

        public void Run(ControllerSet controllerSet)
        {
            string[] data = { "Hdmi", Enable ? "Connect" : "Disconnect" };
            controllerSet.Logger.Write(data);

            controllerSet.Hdmi.Switch(Enable ? 1 : 2);
        }
    }

    public class McciCommand : ICommand
    {
        public bool Enable { get; set; }

        public void Run(ControllerSet controllerSet)
        {
            if (Enable)
            {
                string[] data = { "Mcci", "Connect" };
                controllerSet.Logger.Write(data);

                controllerSet.Mcci.Connect();
            }
            else
            {
                string[] data = { "Mcci", "Disconnect" };
                controllerSet.Logger.Write(data);

                controllerSet.Mcci.Disconnect();
            }
        }
    }

    public class PowerUsbCommand : ICommand
    {
        public int Port { get; set; }
        public bool Enable { get; set; }

        public void Run(ControllerSet controllerSet)
        {
            string[] data = { "PowerUsb", Port.ToString(), Enable ? "Enable" : "Disable" };
            controllerSet.Logger.Write(data);

            controllerSet.PowerUsb.Update(Port, Enable);
        }
    }

    public class SdevUsbCommand : ICommand
    {
        public bool Enable { get; set; }

        public void Run(ControllerSet controllerSet)
        {
            string[] data = { "SdevUsb", Enable ? "Enable" : "Disable" };
            controllerSet.Logger.Write(data);

            controllerSet.Sdev.SwitchUsbPort(Enable);
        }
    }

    public class BatteryLevelCommand : ICommand
    {
        public int Voltage { get; set; }
        public int Percentage { get; set; }

        public void Run(ControllerSet controllerSet)
        {
            string[] data = { "Battery", Voltage.ToString(), Percentage.ToString() };
            controllerSet.Logger.Write(data);

            controllerSet.Sdev.BatteryEmulation(Voltage, Percentage);
        }
    }

    public class PowerButtonCommand : ICommand
    {
        public int HoldTime { get; set; }

        public void Run(ControllerSet controllerSet)
        {
            var task = Task.Run(async () =>
            {
                string[] data = { "PressPowerButton", HoldTime.ToString() };
                controllerSet.Logger.Write(data);

                controllerSet.Sdev.PressPowerButton(HoldTime);

                await Task.Delay(HoldTime);
            });
            task.Wait();
        }
    }

    public class HostProcessCommand : ICommand
    {
        public string Path { get; set; }
        public string Argument { get; set; }

        public void Run(ControllerSet controllerSet)
        {
            string[] data = { "HostProcess", Path, Argument };
            controllerSet.Logger.Write(data);

            // ${...} を環境変数として展開
            var path = Environment.ExpandEnvironmentVariables(Path.Replace("${", "%").Replace("}", "%"));

            Process.Start(path, Argument).WaitForExit();
        }
    }
}
