﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using Microsoft.VisualStudio.Shell.Interop;
using Nintendo.NintendoSdkVsExtension.Base;
using Nintendo.NintendoSdkVsExtension.Shell;
using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Nintendo.NintendoSdkVsExtension.Global
{
    // FIXME:
    // とりあえず状態を放り込む

    public static class GlobalState
    {
        private static IServiceProvider _ServiceProvider;
        public static IServiceProvider ServiceProvider
        {
            get
            {
                Debug.Assert(_ServiceProvider != null, $"{nameof(ServiceProvider)} was referenced before initialization");
                return _ServiceProvider;
            }
        }

        private static VsSolutionEventsSink _VsSolutionEventsSink;
        public static VsSolutionEventsSink VsSolutionEventsSink
        {
            get
            {
                Debug.Assert(_VsSolutionEventsSink != null, $"{nameof(VsSolutionEventsSink)} was referenced before initialization");
                return _VsSolutionEventsSink;
            }
        }

        public static void Initialize(IServiceProvider serviceProvider)
        {
            _ServiceProvider = serviceProvider;
            _VsSolutionEventsSink = new VsSolutionEventsSink(serviceProvider);  // TODO: UI なしの状態でも取得できるかどうか確認する
        }

        public static void Dispose()
        {
            _VsSolutionEventsSink.Dispose();
            _VsSolutionEventsSink = null;
            _ServiceProvider = null;
        }

        // key = IVsHierarchy of type vcxproj
        // SdkProjectSettingsStore
        // ソリューション閉じたタイミングでキャッシュクリア
        // CurrentSdkInformation
        // 現在のプロジェクトの現在の構成のSDK → 現在のプロジェクトの SDK → null
        // LastUsedSdkInformation
        public static bool IsNintendoSdkConfigured()
        {
            throw new NotImplementedException();
        }

        public static SdkInformation GetCurrentNintendoSdkInformation()
        {
            // 現在のプロジェクトの現在の構成のSdkInformation

            throw new NotImplementedException();
        }
    }
}
