﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using Nintendo.NintendoSdkVsExtension.Base;
using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Nintendo.NintendoSdkVsExtension.VcAccessors
{
    public class VcProjectConfigurationAccessor
    {
        private Lazy<IList<VCPropertySheetAccessor>> _propertySheetAccessors;

        internal VcProjectConfigurationAccessor(dynamic vcConfiguration)
        {
            this.InnerObject = vcConfiguration;
            this._propertySheetAccessors = new Lazy<IList<VCPropertySheetAccessor>>(
                () => ((IEnumerable)this.InnerObject.PropertySheets)
                    .Cast<dynamic>()
                    .Select(x => new VCPropertySheetAccessor(x)).ToList());
        }

        public ConfigurationPair ConfigurationPair => new ConfigurationPair(this.ConfigurationName, this.PlatformName);
        public string ConfigurationName => this.InnerObject.ConfigurationName;
        public string PlatformName => this.InnerObject.Platform.Name;
        internal dynamic InnerObject { get; }

        public IEnumerable<VCPropertySheetAccessor> PropertySheets => this._propertySheetAccessors.Value;

        public void RemovePropertySheet(VCPropertySheetAccessor propertySheet)
        {
            this.InnerObject.RemovePropertySheet(propertySheet.InnerObject);
            this._propertySheetAccessors.Value.Remove(propertySheet);
        }

        public VCPropertySheetAccessor AddPropertySheet(string relativeOrFullPath)
        {
            dynamic innerObject = this.InnerObject.AddPropertySheet(relativeOrFullPath);
            var props = new VCPropertySheetAccessor(innerObject);
            this._propertySheetAccessors.Value.Add(props);
            return props;
        }

        public string GetEvaluatedPropertyValue(string propertyName) =>
            this.InnerObject.GetEvaluatedPropertyValue(propertyName);

        public string GetUnevaluatedPropertyValue(string propertyName) =>
            this.InnerObject.GetUnevaluatedPropertyValue(propertyName);
    }
}
