﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Collections.Specialized;
using System.ComponentModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;

namespace Nintendo.NintendoSdkVsExtension.Views
{
    // VS が System.Windows.Interactive を参照していないため VS 拡張から使ってはならないので、最低限のものを再発明する
    // TODO: 実は使っても問題ない可能性が高いので、確認する

    public static class Interaction
    {
        /// <summary>
        /// DependencyObject のコレクションを与える添付プロパティ。
        /// </summary>
        public static readonly DependencyProperty MyInteractionsProperty =
            DependencyProperty.RegisterAttached(
                // プロパティ名を通常と異なる名前にすると、 Get<プロパティ名> 経由で値が取得されるようになる。GetMyInteraction で空コレクションを生成する。
                "_MyInteractions", typeof(InteractionCollection), typeof(Interaction),
                new FrameworkPropertyMetadata());

        public static InteractionCollection GetMyInteractions(DependencyObject d)
        {
            var value = (InteractionCollection)d.GetValue(MyInteractionsProperty);

            if (value == null)
            {
                value = new InteractionCollection();
                d.SetValue(MyInteractionsProperty, value);
                return value;
            }
            else
            {
                return value;
            }
        }
    }

    public class InteractionCollection : FreezableCollection<DependencyObject>
    {
    }
}
