﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using Nintendo.NintendoSdkVsExtension.Base;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Input;

namespace Nintendo.NintendoSdkVsExtension.ViewModels
{
    /// <summary>
    /// 「NintendoSDK のパスを設定する」ダイアログを表す VM
    /// </summary>
    public class ChooseSdkRootViewModel : OkCancelDialogViewModelBase, IDisposable
    {
        private bool _disposedValue = false;
        private Models.ChooseSdkRootDialogModel _model;

        public SdkRootKind Kind
        {
            get { return _model.Kind; }
            set { _model.Kind = value; }
        }

        public string NdiEnvironmentNameValue
        {
            get { return _model.NdiEnvironmentNameValue; }
            set { _model.NdiEnvironmentNameValue = value; }
        }

        public string DirectPropertyValue
        {
            get { return _model.DirectPropertyValue; }
            set { _model.DirectPropertyValue = value; }
        }

        public string EvaluatedSdkRootPath => this._model.EvaluatedSdkRootPath;
        public bool NdiEnvironmentValueEnabled => false;    // TODO: 未実装
        //public bool NdiEnvironmentValueEnabled => this.Kind == SdkRootKind.NdiEnvironmentName;
        public bool DirectPropertyValueEnabled => this.Kind == SdkRootKind.DirectProperty;
        public bool IsInputValid => this._model.IsSdkRootValid;
        public string ErrorMessage => IsInputValid ? string.Empty : this._model.ErrorMessage;

        public ChooseSdkRootViewModel(Models.ChooseSdkRootDialogModel model)
        {
            this._model = model;
            this._model.PropertyChanged += OnModelPropertyChanged;
        }

        #region IDisposable Support
        protected virtual void Dispose(bool disposing)
        {
            if (!_disposedValue)
            {
                if (disposing)
                {
                    this._model.PropertyChanged -= OnModelPropertyChanged;
                }
                _disposedValue = true;
            }
        }

        public void Dispose()
        {
            Dispose(true);
        }
        #endregion

        private void OnModelPropertyChanged(object sender, System.ComponentModel.PropertyChangedEventArgs e)
        {
            switch (e.PropertyName)
            {
                case nameof(this._model.Kind):
                    RaisePropretyChanged(nameof(this.Kind));
                    RaisePropretyChanged(nameof(this.NdiEnvironmentValueEnabled));
                    RaisePropretyChanged(nameof(this.DirectPropertyValueEnabled));
                    break;
                case nameof(this._model.DirectPropertyValue):
                    RaisePropretyChanged(nameof(this.DirectPropertyValue));
                    break;
                case nameof(this._model.EvaluatedSdkRootPath):
                    RaisePropretyChanged(nameof(this.EvaluatedSdkRootPath));
                    break;
                case nameof(this._model.NdiEnvironmentNameValue):
                    RaisePropretyChanged(nameof(this.NdiEnvironmentNameValue));
                    break;
                case nameof(this._model.IsSdkRootValid):
                    RaisePropretyChanged(nameof(this.IsInputValid));
                    break;
                case nameof(this._model.ErrorMessage):
                    RaisePropretyChanged(nameof(this.ErrorMessage));
                    break;
            }
        }
    }
}
