﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using Microsoft.VisualStudio.Shell.Interop;
using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Nintendo.NintendoSdkVsExtension.Shell
{
    public class VsHierarchyEventArgs : EventArgs
    {
        public IVsHierarchy VsHierarchy { get; }
        public VsHierarchyEventArgs (IVsHierarchy vsHierarchy)
        {
            this.VsHierarchy = vsHierarchy;
        }
    }


    public class VsSolutionEventsSink : IVsSolutionEvents, IDisposable
    {
        public event EventHandler<VsHierarchyEventArgs> AfterOpenProject;
        public event EventHandler AfterCloseSolution;

        private bool _disposedValue = false;
        private readonly IVsSolution _solutionService;
        private uint _solutionEventCookie;

        public VsSolutionEventsSink(IServiceProvider serviceProvider)
        {
            this._solutionService = serviceProvider.GetService(typeof(SVsSolution)) as IVsSolution;
            this._solutionService.AdviseSolutionEvents(this, out _solutionEventCookie);
        }

        #region IDisposable Support
        protected virtual void Dispose(bool disposing)
        {
            if (!_disposedValue)
            {
                Debug.Assert(disposing, "must be explicitly disposed");

                this._solutionService.UnadviseSolutionEvents(_solutionEventCookie);
                _disposedValue = true;
            }
        }

        ~VsSolutionEventsSink()
        {
            Dispose(false);
        }

        public void Dispose()
        {
            Dispose(true);
            GC.SuppressFinalize(this);
        }
        #endregion

        public int OnAfterOpenProject(IVsHierarchy pHierarchy, int fAdded)
        {
            AfterOpenProject?.Invoke(this, new VsHierarchyEventArgs(pHierarchy));
            return Microsoft.VisualStudio.VSConstants.S_OK;
        }

        public int OnAfterCloseSolution(object pUnkReserved)
        {
            AfterCloseSolution?.Invoke(this, new EventArgs());
            return Microsoft.VisualStudio.VSConstants.S_OK;
        }

        public int OnAfterLoadProject(IVsHierarchy pStubHierarchy, IVsHierarchy pRealHierarchy) { return Microsoft.VisualStudio.VSConstants.S_OK; }
        public int OnAfterOpenSolution(object pUnkReserved, int fNewSolution) { return Microsoft.VisualStudio.VSConstants.S_OK; }
        public int OnBeforeCloseProject(IVsHierarchy pHierarchy, int fRemoved) { return Microsoft.VisualStudio.VSConstants.S_OK; }
        public int OnBeforeCloseSolution(object pUnkReserved) { return Microsoft.VisualStudio.VSConstants.S_OK; }
        public int OnBeforeUnloadProject(IVsHierarchy pRealHierarchy, IVsHierarchy pStubHierarchy) { return Microsoft.VisualStudio.VSConstants.S_OK; }
        public int OnQueryCloseProject(IVsHierarchy pHierarchy, int fRemoving, ref int pfCancel) { return Microsoft.VisualStudio.VSConstants.S_OK; }
        public int OnQueryCloseSolution(object pUnkReserved, ref int pfCancel) { return Microsoft.VisualStudio.VSConstants.S_OK; }
        public int OnQueryUnloadProject(IVsHierarchy pRealHierarchy, ref int pfCancel) { return Microsoft.VisualStudio.VSConstants.S_OK; }
    }
}
