﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using Nintendo.NintendoSdkVsExtension.Base;
using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;

namespace Nintendo.NintendoSdkVsExtension.ForUIDesign
{
    /// <summary>
    /// MainWindow.xaml の相互作用ロジック
    /// </summary>
    public partial class MainWindow : Window
    {
        public MainWindow()
        {
            InitializeComponent();
        }

        private void SetDialogCommonProperty(Window d, Window parent)
        {
            d.ShowInTaskbar = false;
            d.WindowStartupLocation = WindowStartupLocation.CenterOwner;
            d.Owner = parent;
        }

        private void ButtonSdkConfiguration_Click(object sender, RoutedEventArgs e)
        {
            var model = CreateSdkSolutionModel();
            using (var vm = new ViewModels.SdkConfigurationDialogViewModel(model))
            {
                var dialog = new Views.SdkConfigurationDialog();
                SetDialogCommonProperty(dialog, this);
                dialog.DataContext = vm;
                dialog.ShowDialog();
                if (vm.DialogResult.HasValue)
                {
                    if (vm.DialogResult.Value)
                    {
                        Debug.WriteLine("OK Pressed");
                    }
                    else
                    {
                        Debug.WriteLine("Cancel Pressed");
                    }
                }
                else
                {
                    Debug.WriteLine("Closed");
                }
            }
        }

        private Models.SdkSolution CreateSdkSolutionModel()
        {
            var commonSdkRoot = new SdkRoot(SdkRootKind.DirectProperty, @"c:\NintendoSdk");
            var vcProjects = new Models.SdkVcProject[]
            {
                new Models.SdkVcProject(@"d:\tmp\Hoge.vcxproj", new SdkProjectSettingsStore(
                    new SdkConfigurationSettingsStore[]
                    {
                        new SdkConfigurationSettingsStore(new ConfigurationPair("Win32", "Debug"))
                        {
                            IsSdkEnabled = false, Spec = "Generic", BuildType = SdkBuildType.Debug,
                            SdkRoot = commonSdkRoot,
                        },
                        new SdkConfigurationSettingsStore(new ConfigurationPair("Win32", "Develop"))
                        {
                            IsSdkEnabled = false, Spec = "Generic", BuildType = SdkBuildType.Develop,
                            SdkRoot = commonSdkRoot,
                        },
                        new SdkConfigurationSettingsStore(new ConfigurationPair("Win32", "Release"))
                        {
                            IsSdkEnabled = false, Spec = "Generic", BuildType = SdkBuildType.Release,
                            SdkRoot = commonSdkRoot,
                        },
                        new SdkConfigurationSettingsStore(new ConfigurationPair("x64", "Debug"))
                        {
                            IsSdkEnabled = false, Spec = "Generic", BuildType = SdkBuildType.Debug,
                            SdkRoot = commonSdkRoot,
                        },
                        new SdkConfigurationSettingsStore(new ConfigurationPair("x64", "Develop"))
                        {
                            IsSdkEnabled = false, Spec = "Generic", BuildType = SdkBuildType.Develop,
                            SdkRoot = commonSdkRoot,
                        },
                        new SdkConfigurationSettingsStore(new ConfigurationPair("x64", "Release"))
                        {
                            IsSdkEnabled = false, Spec = "Generic", BuildType = SdkBuildType.Release,
                            SdkRoot = commonSdkRoot,
                            // 未実装
                            // SdkRoot = new SdkRoot(SdkRootKind.NdiEnvironmentName, "NDIHoge"),
                        },
                    })),
                new Models.SdkVcProject(@"d:\tmp\Fuga.vcxproj", new SdkProjectSettingsStore(
                    new SdkConfigurationSettingsStore[]
                    {
                        new SdkConfigurationSettingsStore(new ConfigurationPair("Win32", "Debug"))
                        {
                            IsSdkEnabled = true, Spec = "Generic", BuildType = SdkBuildType.Debug,
                            SdkRoot = commonSdkRoot,
                        },
                        new SdkConfigurationSettingsStore(new ConfigurationPair("Win32", "Develop"))
                        {
                            IsSdkEnabled = true, Spec = "Generic", BuildType = SdkBuildType.Develop,
                            SdkRoot = commonSdkRoot,
                        },
                        new SdkConfigurationSettingsStore(new ConfigurationPair("Win32", "Release"))
                        {
                            IsSdkEnabled = true, Spec = "Generic", BuildType = SdkBuildType.Release,
                            SdkRoot = commonSdkRoot,
                        },
                        new SdkConfigurationSettingsStore(new ConfigurationPair("x64", "Debug"))
                        {
                            IsSdkEnabled = true, Spec = "Generic", BuildType = SdkBuildType.Debug,
                            SdkRoot = commonSdkRoot,
                        },
                        new SdkConfigurationSettingsStore(new ConfigurationPair("x64", "Develop"))
                        {
                            IsSdkEnabled = true, Spec = "Generic", BuildType = SdkBuildType.Develop,
                            SdkRoot = commonSdkRoot,
                        },
                        new SdkConfigurationSettingsStore(new ConfigurationPair("x64", "Release"))
                        {
                            IsSdkEnabled = true, Spec = "Generic", BuildType = SdkBuildType.Release,
                            SdkRoot = new SdkRoot(SdkRootKind.DirectProperty, @"d:\ForConfigurationHoge\"),
                        },
                    }))
            };

            return new Models.SdkSolution(vcProjects);
        }

        private void ButtonSdkPath_Click(object sender, RoutedEventArgs e)
        {
            ShowChooseSdkRootDialog(
                new SdkRoot(SdkRootKind.DirectProperty, "$(NINTENDO_SDK_ROOT)"));
        }

        private void ShowChooseSdkRootDialog(SdkRoot sdkRoot)
        {
            var model = new Models.ChooseSdkRootDialogModel(sdkRoot);
            var vm = new ViewModels.ChooseSdkRootViewModel(model);
            var dialog = new Views.ChooseSdkRootDialog();
            SetDialogCommonProperty(dialog, this);
            dialog.DataContext = vm;
            var result = dialog.ShowDialog();
            if (vm.DialogResult.HasValue)
            {
                if (vm.DialogResult.Value)
                {
                    Debug.WriteLine("OK Pressed");
                    var newSdkRoot = model.ToSdkRoot();
                    Debug.WriteLine("Kind: {0}, Value: {1}", newSdkRoot.Kind, newSdkRoot.Value);
                }
                else
                {
                    Debug.WriteLine("Cancel Pressed");
                }
            }
            else
            {
                Debug.WriteLine("Closed");
            }
        }
    }
}
