# coding: UTF-8

# Copyright (C)Nintendo All rights reserved.
#
# These coded instructions, statements, and computer programs contain proprietary
# information of Nintendo and/or its licensed developers and are protected by
# national and international copyright laws. They may not be disclosed to third
# parties or copied or duplicated in any form, in whole or in part, without the
# prior written consent of Nintendo.
#
# The content herein is highly confidential and should be handled accordingly.

from timeit import default_timer as timer
import sys
import os
import shutil

#Add/Remove from this as required samples change.
sampleNames = [
"AudioRenderer",
"AudioOut",
"AtkSimple",
]

status_format = "{: <10} {: <25} {: <15} {:<15}"
def PrintStatus(platform, name, result, time):
    if(result == 0):
        print (status_format.format(platform, name, "BUILT", time))
    else:
        print (status_format.format(platform, name, "**NOT BUILT**", time))
    return

#Pass all args to make, except arg[0] (which is the script program name)
WIN_ARGS = "platforms=Win32 BUILD=Develop"
NX_ARGS = "platforms=NXFP2 specs=NX BUILD=Develop"
MAKE_ARGS = ""

skip_dependencies = False
build_nx = True
build_win = True
for arg in sys.argv[1:]:
    if "-skip-libs" == arg.lower():
        print "Skipping libs"
        skip_dependencies = True
    elif arg.startswith("-samples="):
        sampleNames = []
        arg = arg[9:len(arg)]
        
        for sample in arg.split(','):
            sample = sample.strip()
            sampleNames.append(sample)
    elif "-skip-nx" == arg.lower():
        build_nx = False
    elif "-skip-win" == arg.lower():
        build_win = False
    elif len(arg) > 0:
        print "Arguments are not case sensitive, sample names are"
        print "-skip-libs" 
        print "\tSkips building adsp-os, audio_libs. Jumps straight to samples"
        print "-samples=\"[sampleNames]\""
        print "\tsamplesNames is a comma delimited list."
        print "\ti.e. build_Audio_Samples.cmd -samples=\"AudioLLSimple , AudioLLVolumeEnvelope\" builds only AudioLLSimple and AudioLLVolumeEnvelope"
        sys.exit(0)

print "Building samples "
print "\t" + str(sampleNames)


#Set path variables
APP_ROOT   = os.path.dirname( os.path.abspath(__file__) )
SIGLO_ROOT = os.path.normpath( APP_ROOT + '/../../../..' )
BUILD_PATH = SIGLO_ROOT + "/Externals/nx_ape"

#Try to get TOOLCHAIN_PREFIX, fallback to hardcoded default if necessary
ADSP_GCC_ROOT = os.environ.get("ADSP_GCC_ROOT")
if ADSP_GCC_ROOT is None:
    print "[Notice] ADSP_GCC_ROOT is undefined - if make fails, try setting ADSP_GCC_ROOT environment variable"
    print "[Notice] Setting ADSP_GCC_ROOT to c:/Tools/gcc-linaro-arm-none-eabi-4.8-2014.04_win32 for this session"
    os.environ["ADSP_GCC_ROOT"] = "c:/Tools/gcc-linaro-arm-none-eabi-4.8-2014.04_win32"

#Make sure SigloRootMark exists
if not os.path.isfile(SIGLO_ROOT + "/SigloRootMark"):
    print "Error: could not find SigloRootMark. Did you move MakeAdspOs.py?"
    print "Exiting."
    sys.exit(0)

print "Modify Integrate/Sources/Tools/MakeAudioSamples/MakeAudioSamples.py to adjust settings"

if not os.path.exists(SIGLO_ROOT + "/BuildLogs"):
    os.mkdir(SIGLO_ROOT + "/BuildLogs")

print status_format.format("Platform", "Name", "Build Status", "Build Time(sec)"); 

result = 0
if skip_dependencies == False and build_nx == True:
    #call make
    time = timer()
    result = os.system("make renderer -C " + BUILD_PATH + "> " + SIGLO_ROOT + "/BuildLogs/adsp_make.txt 2>&1")

    time = timer() - time
    PrintStatus("DSP", "adsp-os", result, time)


can_build_win_samples = True
can_build_nx_samples = True
if result == 0 and skip_dependencies == False:
    if build_win:
        time = timer()
        result = os.system("nact " + WIN_ARGS + " outputs=vcprojects -d " + SIGLO_ROOT + "/Programs/Iris/Sources/Libraries/audio/ > " + SIGLO_ROOT + "/BuildLogs/WIN_libs_nact.txt 2>&1")
        result = os.system("nact " + WIN_ARGS + " outputs=vcfilters -d " + SIGLO_ROOT + "/Programs/Iris/Sources/Libraries/audio/ > " + SIGLO_ROOT + "/BuildLogs/WIN_libs_nact.txt 2>&1")
        result = os.system("nact " + WIN_ARGS + " -d " + SIGLO_ROOT + "/Programs/Iris/Sources/Libraries/audio/ > " + SIGLO_ROOT + "/BuildLogs/WIN_libs_nact.txt 2>&1")
        time = timer() - time
        PrintStatus("WIN", "audio libs", result, time)
        if result != 0:
            can_build_win_samples = False
    if build_nx:
        time = timer()
        result = os.system("nact " + NX_ARGS + " outputs=vcprojects -d " + SIGLO_ROOT + "/Programs/Iris/Sources/Libraries/audio/ > " + SIGLO_ROOT + "/BuildLogs/NX_libs_nact.txt 2>&1")
        result = os.system("nact " + NX_ARGS + " outputs=vcfilters -d " + SIGLO_ROOT + "/Programs/Iris/Sources/Libraries/audio/ > " + SIGLO_ROOT + "/BuildLogs/NX_libs_nact.txt 2>&1")
        result = os.system("nact " + NX_ARGS + " -d " + SIGLO_ROOT + "/Programs/Iris/Sources/Libraries/audio/ > " + SIGLO_ROOT + "/BuildLogs/NX_libs_nact.txt 2>&1")
        time = timer() - time
        PrintStatus("NX", "audio libs", result, time)
        
        if result != 0:
            can_build_nx_samples = False;
        else:
            time = timer()
            result = os.system("nact " + NX_ARGS + " -d " + SIGLO_ROOT + "/Programs/Iris/Sources/Processes/audio/ > " + SIGLO_ROOT + "/BuildLogs/NX_process_nact.txt 2>&1")
            time = timer() - time
            PrintStatus("NX", "audio proc", result, time)

elif result != 0:
    print "Could not build adsp. See BuildLogs/asdp_make.txt for detail"
    sys.exit(1)

#Remove old log files
for root, dirs, files in os.walk(SIGLO_ROOT + "/BuildLogs/NX"):
    for f in files:
        os.unlink(os.path.join(root, f))
for root, dirs, files in os.walk(SIGLO_ROOT + "/BuildLogs/Win"):
    for f in files:
        os.unlink(os.path.join(root, f))
if not os.path.exists(SIGLO_ROOT + "/BuildLogs/Win"):
    os.mkdir(SIGLO_ROOT + "/BuildLogs/Win")
if not os.path.exists(SIGLO_ROOT + "/BuildLogs/NX"):
    os.mkdir(SIGLO_ROOT + "/BuildLogs/NX")
    
WinPass = 0
WinFail = 0
NXPass = 0
NXFail = 0

for name in sampleNames:
    if len(name) == 0:
        continue
    if build_win and can_build_win_samples:
        time = timer()
        result = os.system("nact " + WIN_ARGS + " outputs=vcprojects -d " + SIGLO_ROOT + "/Samples/Sources/Applications/" + name + "/ > " + SIGLO_ROOT + "/BuildLogs/tmp.txt 2>&1")
        result = os.system("nact " + WIN_ARGS + " outputs=vcfilters -d " + SIGLO_ROOT + "/Samples/Sources/Applications/" + name + "/ > " + SIGLO_ROOT + "/BuildLogs/tmp.txt 2>&1")
        result = os.system("nact " + WIN_ARGS + " outputs=samples -d " + SIGLO_ROOT + "/Samples/Sources/Applications/" + name + "/ > " + SIGLO_ROOT + "/BuildLogs/tmp.txt 2>&1")
        time = timer() - time;
        PrintStatus("WIN", name, result, time)
        if result == 0:
            shutil.copy(SIGLO_ROOT + "/BuildLogs/tmp.txt", SIGLO_ROOT + "/BuildLogs/Win/PASS_" + name + ".txt")
            WinPass += 1
        else:
            shutil.copy(SIGLO_ROOT + "/BuildLogs/tmp.txt", SIGLO_ROOT + "/BuildLogs/Win/FAIL_" + name + ".txt")
            WinFail += 1
    if build_nx and can_build_nx_samples:
        time = timer()
        result = os.system("nact " + NX_ARGS + " outputs=vcprojects -d " + SIGLO_ROOT + "/Samples/Sources/Applications/" + name + "/ > " + SIGLO_ROOT + "/BuildLogs/tmp.txt 2>&1")
        result = os.system("nact " + NX_ARGS + " outputs=vcfilters -d " + SIGLO_ROOT + "/Samples/Sources/Applications/" + name + "/ > " + SIGLO_ROOT + "/BuildLogs/tmp.txt 2>&1")
        result = os.system("nact " + NX_ARGS + " outputs=samples -d " + SIGLO_ROOT + "/Samples/Sources/Applications/" + name + "/ > " + SIGLO_ROOT + "/BuildLogs/tmp.txt 2>&1")
        time = timer() - time;

        PrintStatus("NX", name, result, time)
        if result == 0:
            shutil.copy(SIGLO_ROOT + "/BuildLogs/tmp.txt", SIGLO_ROOT + "/BuildLogs/NX/PASS_" + name + ".txt")
            NXPass += 1
        else:
            shutil.copy(SIGLO_ROOT + "/BuildLogs/tmp.txt", SIGLO_ROOT + "/BuildLogs/NX/FAIL_" + name + ".txt")
            NXFail += 1
            
print "*********************************************************************"
print "Windows Failed samples: " + str(WinFail)
print "Windows Passed samples: " + str(WinPass)
print "NX Failed samples: " + str(NXFail)
print "NX Passed samples: " + str(NXPass)
print "Build complete. See <SDK>/BuildLogs for detailed results"
print "*********************************************************************"

sys.exit(0)