# coding: UTF-8

# Copyright (C)Nintendo All rights reserved.
#
# These coded instructions, statements, and computer programs contain proprietary
# information of Nintendo and/or its licensed developers and are protected by
# national and international copyright laws. They may not be disclosed to third
# parties or copied or duplicated in any form, in whole or in part, without the
# prior written consent of Nintendo.
#
# The content herein is highly confidential and should be handled accordingly.

import sys
import os
import shutil

#Set path variables
APP_ROOT   = os.path.dirname( os.path.abspath(__file__) )
SIGLO_ROOT = os.path.normpath( APP_ROOT + '/../../../..' )
BUILD_PATH = SIGLO_ROOT + "/Externals/nx_ape"

#Make sure SigloRootMark exists
if not os.path.isfile(SIGLO_ROOT + "/SigloRootMark"):
    print "Error: could not find SigloRootMark. Did you move MakeAdspOs.py?"
    print "Exiting."
    sys.exit(1)

#Pass all args to make, except arg[0] (which is the script program name)
skip_copy = False
CMD_LINE_ARGS = ""
for arg in sys.argv[1:]:
    CMD_LINE_ARGS += arg + " "
    if arg == "clean":
        skip_copy = True

#call make
result = os.system("make -C " + BUILD_PATH + " " + CMD_LINE_ARGS)
sys.exit(result)