# coding: UTF-8

# Copyright (C)Nintendo All rights reserved.
#
# These coded instructions, statements, and computer programs contain proprietary
# information of Nintendo and/or its licensed developers and are protected by
# national and international copyright laws. They may not be disclosed to third
# parties or copied or duplicated in any form, in whole or in part, without the
# prior written consent of Nintendo.
#
# The content herein is highly confidential and should be handled accordingly.

import argparse
import re
import xml.etree.ElementTree as ET

def main(input_file, check_file):
    """
    Args:
        input_file: チェックするプライベートAPIリストのファイル
        check_file: チェックに使用するアプリケーションの programinfo.xml ファイル
    """

    private_api_tree = ET.parse(input_file)
    private_api_root = private_api_tree.getroot()

    programinfo_tree = ET.parse(check_file)
    programinfo_root = programinfo_tree.getroot()

    for unresolved_api in programinfo_root.getiterator("UnresolvedApi"):
        # チェック対象の programinfo に登録してある ApiName をチェックする
        use_symbol_name = unresolved_api.find(".//ApiName").text
        use_nso_name = unresolved_api.find(".//NsoName").text
        for api_name in private_api_root.getiterator("api"):
            id_name = api_name.find(".//id").text
            xpath = api_name.find(".//xpath").text
            private_api_list_text = re.sub(r'\/ProgramInfo\/SdkVersion\[ starts-with\(\., \'1_\' \) \]\/following\-sibling::UnresolvedApiList\/UnresolvedApi\/ApiName', "", xpath)
            private_api_list = re.findall(r'\'(\w+)\'', private_api_list_text)
            for private_api_name in private_api_list:
                if use_symbol_name == private_api_name:
                    print "Find private api"
                    print "ApiName : " + use_symbol_name
                    print "NsoName : " + use_nso_name
                    print "id : " + id_name
                    print "\n"


if __name__ == '__main__':
    parser = argparse.ArgumentParser()
    parser.add_argument('--target', help='programinfo.xml file')
    parser.add_argument('--input', help='api-list.xml file')
    args = parser.parse_args()

    check_file = args.target
    input_file = args.input

    main(input_file, check_file)
