﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.IO;

using LOG = Common.Logger;

namespace Common
{
    public class UtilFs
    {
        private const string DoxygenHtmlDirName = "\\Html";
        private const string DoxygenXmlDirName = "\\Xml";
        private const string DoxygenXmlPreDirName = "\\Xml_pre";
        private const string DocumentSourcesDirName = "\\Sources";
        public const string DoxygenIndexXmlName = "index.xml";

        private const int DeleteCountMax = 60;

        private static string VsHelpDirName = null;
        private static string VsHelpBaseDirName = null;

        public static void SetVsHelpDirName(string path)
        {
            VsHelpDirName = "\\" + path;
        }

        public static void SetVsHelpBaseDirName(string path)
        {
            VsHelpBaseDirName = "\\" + path;
        }

        public static string GetHtmlDirName()
        {
            return VsHelpBaseDirName + DoxygenHtmlDirName;
        }

        public static string GetXmlDirName()
        {
            return VsHelpBaseDirName + DoxygenXmlDirName;
        }

        public static string GetXmlPreDirName()
        {
            return VsHelpBaseDirName + DoxygenXmlPreDirName;
        }

        public static string GetGeneratedSourcesDirName()
        {
            return VsHelpBaseDirName + DocumentSourcesDirName;
        }

        public static string GetHelpOutputDirName()
        {
            return VsHelpDirName;
        }

        public static void FileCheckDelete(string path)
        {
            if (File.Exists(path))
            {
                File.Delete(path);
            }
        }

        public static bool RenameBackupFile(string path, string newpath)
        {
            // オリジナルファイルを削除しその名前にリネームする
            File.Delete(path);
            int delCount = 0;
            while (File.Exists(path))
            {
                if (delCount++ >= DeleteCountMax)
                {
                    //タイムアウトが来たら諦める
                    break;
                }
                System.Threading.Thread.Sleep(1000);
            }
            File.Move(newpath, path);
            return true;
        }

        public static string ConvertFullPath(string path)
        {
            Uri u = new Uri(path);
            return u.LocalPath;
        }

        public static string AdjustDirectoryPath(string path)
        {
            // ディレクトリ終端の\を削除(共通APIとして)
            // 環境変数を展開
            if (path == null)
            {
                return null;
            }
            char[] endchar = { '\\' };
            string retpath = path.TrimEnd(endchar);
            if (retpath == null)
            {
                return null;
            }
            retpath = Environment.ExpandEnvironmentVariables(retpath);
            return retpath;
        }

        private static HashSet<string> DoxygenHtmlFileNameHash;
        private static bool DoxygenHtmlFileNameHashInitialized = false;

        public static bool InitalizeDoxygenHtmlFileNameHash(string doxygenPath)
        {
            string[] fileArray = Directory.GetFiles(doxygenPath, "*.html");
            fileArray = Array.ConvertAll(fileArray, i => Path.GetFileName(i));
            DoxygenHtmlFileNameHash = new HashSet<string>(fileArray);
            DoxygenHtmlFileNameHashInitialized = true;
            return true;
        }

        public static bool CheckDoxygenHtmlFileExist(string filePath)
        {
            if (DoxygenHtmlFileNameHashInitialized == false)
            {
                LOG.LogLine(LOG.Level.LOG_ERROR, "DoxygenHtmlFileNameHash is not initialized.");
            }
            return DoxygenHtmlFileNameHash.Contains(filePath);
        }

        public static string[] GetDoxygenHtmlFiles()
        {
            if (DoxygenHtmlFileNameHashInitialized == false)
            {
                LOG.LogLine(LOG.Level.LOG_ERROR, "DoxygenHtmlFileNameHash is not initialized.");
            }
            return DoxygenHtmlFileNameHash.ToArray();
        }
    }
}
