﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.IO;

using LOG = Common.Logger;

namespace Common
{
    public class UtilCmdline
    {
        public static bool CheckInputDirArgument(string arg)
        {
            if (arg.Substring(0, 1) == "-")
            {
                LOG.Log(LOG.Level.LOG_ERROR, "--in-dir-name needs directory name");
                return false;
            }
            return true;
        }

        public static bool CheckOutputDirArgument(string arg)
        {
            if (arg.Substring(0, 1) == "-")
            {
                LOG.Log(LOG.Level.LOG_ERROR, "--out-dir-name needs directory name");
                return false;
            }
            return true;
        }
    }
}
