﻿namespace DotNetAssemblyAttributeWriter
{
    using System.IO;
    using System.Text;
    using System.Text.RegularExpressions;

    /// <summary>
    /// アセンブリ情報を書き込むクラスです。
    /// </summary>
    internal static class AssemblyInfoWriter
    {
        public static void UpdateAssemblyInfo(string filePath, string companyName, string copyrightName)
        {
            var text = File.ReadAllText(filePath, Encoding.UTF8);

            // AssemblyCompany の更新
            text = Regex.Replace(
                text,
                "\\[assembly: AssemblyCompany\\(\".*\"\\)\\]",
                "[assembly: AssemblyCompany(\"" + companyName + "\")]");

            // AssemblyCopyright の更新
            text = Regex.Replace(
                text,
                "\\[assembly: AssemblyCopyright\\(\".*\"\\)\\]",
                "[assembly: AssemblyCopyright(\"Copyright (C)" + copyrightName + ". All rights reserved.\")]");

            File.WriteAllText(filePath, text, Encoding.UTF8);
        }
    }
}
