﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace MakeDictionarySource
{
    class Utils
    {
        // Util クラスなのでインスタンス化禁止
        private Utils()
        {
        }

        /// <summary>
        /// モジュール名からユーザーに提供するマクロの名前を生成して返します。
        /// </summary>
        /// <param name="moduleName">モジュール名</param>
        /// <returns>ユーザーに提供するマクロの名前</returns>
        public static string GetMacroName(string moduleName)
        {
            return "NN_TEXT_" + moduleName.ToUpper();
        }

        /// <summary>
        /// モジュール名から辞書検索関数の名前を生成して返します。
        /// </summary>
        /// <param name="moduleName">モジュール名</param>
        /// <returns>辞書検索関数の名前</returns>
        public static string GetFunctionName(string moduleName)
        {
            return "nnText_" + moduleName;
        }

        /// <summary>
        /// モジュール名から辞書データ配列の名前を生成して返します。
        /// </summary>
        /// <param name="moduleName">モジュール名</param>
        /// <returns>辞書データ配列の名前</returns>
        public static string GetArrayName(string moduleName)
        {
            return GetFunctionName(moduleName) + "_dictionary";
        }

        /// <summary>
        /// インクルード対象からインクルード文を生成して返します。改行は含めません。
        /// includeTarget が null なら、インクルード分を生成せず、空文字列を返します。
        /// </summary>
        /// <param name="includeTarget">インクルード対象</param>
        /// <returns>インクルード対象</returns>
        public static string GetIncludeExpression(string includeTarget)
        {
            if (includeTarget == null)
            {
                return "";
            }

            return "#include " + includeTarget;
        }
    }
}
