﻿<#
    Copyright (C)Nintendo All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.

    The content herein is highly confidential and should be handled accordingly.
#>

<#
    .SYNOPSIS
        Initialize sdev by system updater.

    .DESCRIPTION
        Initialize sdev by system updater.
#>
[CmdletBinding()]
Param
(
    # The host IP address pattern as RegularExpression
    [Parameter(Mandatory=$true)]
    [string]
    $AddressPattern = '.*',
    
    [string]
    $UpdateImagePath
)

$scriptPath          = $MyInvocation.MyCommand.Path
$scriptDirectoryPath = [System.IO.Path]::GetDirectoryName($scriptPath)

Import-Module "${scriptDirectoryPath}/Modules/Error"
Import-Module "${scriptDirectoryPath}/Modules/Path"
Import-Module "${scriptDirectoryPath}/Modules/HostBridge"
Import-Module "${scriptDirectoryPath}/Modules/Utility"

$RestartHostBridge  = "$(Get-NintendoSdkRootPath)/Integrate/Scripts/NX/Recovery/Restart-HostBridge.ps1"

trap [Exception]
{
    Write-ErrorRecord $_
    exit 1
}

Test-ParameterIsNotNullOrEmpty -Name "AddressPattern" -Value $AddressPattern

# Get the address of the HostBridge
$TargetAddress = Get-SigleTargetAddress -AddressPattern $AddressPattern
$TargetSerial = Get-SerialNumber -HostBridgeAddress $TargetAddress

# Update
$Updated = $false
if([String]::IsNullOrEmpty($UpdateImagePath))
{
    Update-HostBridge -HostBridgeAddress $TargetAddress -Updated ([ref]$Updated)
}
else
{
    Update-HostBridge -HostBridgeAddress $TargetAddress -FirmwareImagePath $UpdateImagePath -Updated ([ref]$Updated)
}

if(!$Updated)
{
    exit 0
}

Stop-SaveHostBridgeLog -HostBridgeAddress $TargetAddress

$TargetAddress = Get-TargetAddressFromSerial -Target $TargetSerial
Start-SaveHostBridgeLog -HostBridgeAddress $TargetAddress -rebooted
