<#
    Copyright (C)Nintendo All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.

    The content herein is highly confidential and should be handled accordingly.
#>

<#
    .SYNOPSIS
        Write the BootConfig by FRCM
#>
[CmdletBinding()]
Param
(
    [string]
    $BootConfig = '', # Invalid, <BootConfigFile>

    [string]
    $KeyType = 'K3' # K1, K2, K3
)

$scriptPath          = $MyInvocation.MyCommand.Path
$scriptDirectoryPath = [System.IO.Path]::GetDirectoryName($scriptPath)

Import-Module "${scriptDirectoryPath}/../../Modules/Error"
Import-Module "${scriptDirectoryPath}/../../Modules/Path"
Import-Module "${scriptDirectoryPath}/../../Modules/Utility"
Import-Module "${scriptDirectoryPath}/../../Modules/Runner"
Import-Module "${scriptDirectoryPath}/../../Modules/UsbTarget"

$RcmWriter          = "$(Get-NintendoSdkRootPath)/Externals/NxSystemImages/RcmWriter/RcmWriter.exe"
$RcmWriterRcm       = "$(Get-NintendoSdkRootPath)/Externals/NxSystemImages/RcmWriter/RcmWriter.$KeyType.rcm"
$RcmWriterXml       = "$(Get-NintendoSdkRootPath)/Integrate/Sources/Configs/RcmWriter/Write-BootConfig.xml"
$RcmWriterRcmOld    = "$(Get-NintendoSdkRootPath)/Externals/NxSystemImages/RcmWriter/RcmWriter.$KeyType.old.rcm"
$BootConfigInRepo   = "$(Get-NintendoSdkRootPath)/Externals/NxBootConfigs/bc-$BootConfig.bin"
$BootConfigDummy    = "$(Get-NintendoSdkRootPath)/Externals/NxBootConfigs/bc-dummy.bin"
$RcmWriterAdditionalOptions = ""

if($KeyType -eq 'M2')
{
    $RcmWriterAdditionalOptions = "--old_rcm `"$RcmWriterRcmOld`""
}

$OutputDirectory    = "$(Get-NintendoSdkRootPath)/Integrate/Outputs/RcmWriter"
$OutputConfig       = "$OutputDirectory/RcmWriterConfig.xml"
$OutputBootConfig   = "$OutputDirectory/BootConfig.img"

trap [Exception]
{
    Write-ErrorRecord $_
    exit 1
}

if (!(Test-Path $OutputDirectory)) {
    mkdir $OutputDirectory > $null
}

if($BootConfig -ne "Invalid")
{    
    if(Test-Path $BootConfig)
    {
        $BootConfigFile = $BootConfig
    }
    elseif(Test-Path $BootConfigInRepo)
    {
        $BootConfigFile = $BootConfigInRepo
    }
    else
    {
        throw "Not found the boot config file: $BootConfig"
    }
}
else
{
    $BootConfigFile = $BootConfigDummy
}

cp $BootConfigFile $OutputBootConfig
Write-Host "  BootConfigFile:  $BootConfigFile"

# Test existing files
Test-EnsureExistPath $RcmWriter
Test-EnsureExistPath $RcmWriterRcm
Test-EnsureExistPath $RcmWriterXml
Test-EnsureExistPath $BootConfigFile

# Copy files
cp $RcmWriterXml $OutputConfig

# RcmWriter
Invoke-CriticalCommand "& `"$RcmWriter`" --rcm `"$RcmWriterRcm`" --list `"$OutputConfig`" $RcmWriterAdditionalOptions"
