<#
    Copyright (C)Nintendo All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.

    The content herein is highly confidential and should be handled accordingly.
#>

<#
    .SYNOPSIS
        Create ProdTesting InitialImage nfa

    .DESCRIPTION
        Create ProdTesting InitialImage nfa
#>
[CmdletBinding()]
Param
(
    [string]
    $KeyType = 'K5',
    
    [string]
    $ConnectionType = 'Manu',
    
    [string]
    $SignedType = 'Signed',
    
    [string]
    $BootType = 'ManuBoot',
    
    [string]
    $StorageSize = '32G',
    
    [string]
    $DeveloperType = 'ManufacturingTest',
    
    [string]
    $BuildType = 'Release',
    
    [string]
    $Platform = 'NX-NXFP2-a64',
    
    [string]
    $ConvertYamlFile = ""
)

$scriptDirectoryPath = [System.IO.Path]::GetDirectoryName($MyInvocation.MyCommand.Path)

Import-Module "${scriptDirectoryPath}/../../Modules/Error"
Import-Module "${scriptDirectoryPath}/../../Modules/Path"
Import-Module "${scriptDirectoryPath}/../../Modules/Utility"

if("" -eq $ConvertYamlFile)
{
    $ConvertYamlFile = "$(Get-NintendoSdkRootPath)/Integrate/Scripts/NX/Manufacturing/Manufacture-ConvertToProdMpImage-K6.yml"
}

$ProdKeyType = "K6"
$MakeFirmwareArchive  = "$(Get-NintendoSdkRootPath)/Tools/CommandLineTools/MakeFirmwareArchive/MakeFirmwareArchive.exe"
$ImageType = "NX-$KeyType-$ConnectionType-$SignedType-$BootType-$StorageSize-$DeveloperType"
$ProdImageType = "NX-$ProdKeyType-$ConnectionType-$SignedType-$BootType-$StorageSize-$DeveloperType"
$NfaPath = "$(Get-NintendoSdkRootPath)/Programs/Eris/Outputs/$Platform/FirmwareArchives/$ImageType/$BuildType/$ImageType.nfa"
$ReplacedProdNfaPath = "$(Get-NintendoSdkRootPath)/Programs/Eris/Outputs/$Platform/FirmwareArchives/$ProdImageType/$BuildType/$ProdImageType.nfa"
$ymlPath = "$ConvertYamlFile-tmp.yml"

Get-Content $ConvertYamlFile | foreach { 
    $ConvertRule += $_ -creplace "{SigloRoot}", "$(Get-NintendoSdkRootPath)"
    $ConvertRule += "`r`n"
 }
 
$ConvertRule | Out-File $ymlPath
 
$ReplacedProdNfaDirectoryPath = [System.IO.Path]::GetDirectoryName($ReplacedProdNfaPath)
if (!(Test-Path $ReplacedProdNfaDirectoryPath)) {
    New-Item $ReplacedProdNfaDirectoryPath -itemType Directory | Out-Null
}
 
Invoke-Expression "& `"$MakeFirmwareArchive`" executelist -i `"$NfaPath`" -o `"$ReplacedProdNfaPath`" --list `"$ymlPath`""

Remove-Item $ymlPath