<#
    Copyright (C)Nintendo All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.

    The content herein is highly confidential and should be handled accordingly.
#>

<#
    .SYNOPSIS
        Merge ProdTesting InitialImage nfa

    .DESCRIPTION
        Merge ProdTesting InitialImage nfa
#>
[CmdletBinding()]
Param
(
    [string]
    $KeyType = 'K6',
    
    [string]
    $ConnectionType = 'Manu',
    
    [string]
    $SignedType = 'Signed',
    
    [string]
    $BootType = 'ManuBoot',
    
    [string]
    $StorageSize = '32G',
    
    [string]
    $DeveloperType = 'ManufacturingTest',
    
    [string]
    $BuildType = 'Release',
    
    [string]
    $Platform = 'NX-NXFP2-a64',
    
    [string]
    $CovertYamlFile = ""
)

$scriptDirectoryPath = [System.IO.Path]::GetDirectoryName($MyInvocation.MyCommand.Path)

Import-Module "${scriptDirectoryPath}/../../Modules/Error"
Import-Module "${scriptDirectoryPath}/../../Modules/Path"
Import-Module "${scriptDirectoryPath}/../../Modules/Utility"

if($null -eq $ConvertYamlFile)
{
    $ConvertYamlFile = "$(Get-NintendoSdkRootPath)/Integrate/Scripts/NX/Manufacturing/Manufacture-AddInspectionSoftware-K6.yml"
}

$ProdKeyType = "K6"
$MakeFirmwareArchive  = "$(Get-NintendoSdkRootPath)/Tools/CommandLineTools/MakeFirmwareArchive/MakeFirmwareArchive.exe"
$ProdImageType = "NX-$ProdKeyType-$ConnectionType-$SignedType-$BootType-$StorageSize-$DeveloperType"
$ReplacedProdNfaPath = "$(Get-NintendoSdkRootPath)/Programs/Eris/Outputs/$Platform/FirmwareArchives/$ProdImageType/$BuildType/$ProdImageType.nfa"
$MergedProdNfaPath = "$(Get-NintendoSdkRootPath)/Programs/Eris/Outputs/$Platform/FirmwareArchives/$ProdImageType/$BuildType/$ProdImageType.tmp.nfa"

$ymlPath = "$ConvertYamlFile-tmp.yml"

Get-Content $ConvertYamlFile | foreach { 
    $ConvertRule += $_ -creplace "{SigloRoot}", "$(Get-NintendoSdkRootPath)"
    $ConvertRule += "`r`n"
 }
 
$ConvertRule | Out-File $ymlPath
 
Invoke-Expression "& `"$MakeFirmwareArchive`" executelist -i `"$ReplacedProdNfaPath`" -o `"$MergedProdNfaPath`" --list `"$ymlPath`""

Remove-Item $ymlPath

Move-Item $MergedProdNfaPath $ReplacedProdNfaPath -force